/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpManager {
    protected static final Logger log = LoggerFactory.getLogger(SmtpManager.class);
    Incoming _incomingQueue;
    UserManager userManager;
    private ImapHostManager imapHostManager;
    List<WaitObject> notifyList;

    public SmtpManager(ImapHostManager imapHostManager, UserManager userManager) {
        this.imapHostManager = imapHostManager;
        this.userManager = userManager;
        this._incomingQueue = new Incoming();
        this.notifyList = Collections.synchronizedList(new ArrayList());
    }

    public String checkSender(SmtpState state, MailAddress sender) {
        return null;
    }

    public String checkRecipient(SmtpState state, MailAddress rcpt) {
        return null;
    }

    public String checkData(SmtpState state) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(SmtpState state) {
        this._incomingQueue.enqueue(state.getMessage());
        Iterator<WaitObject> i$ = this.notifyList.iterator();
        while (i$.hasNext()) {
            WaitObject o;
            WaitObject waitObject = o = i$.next();
            synchronized (waitObject) {
                o.emailReceived();
            }
        }
    }

    public synchronized WaitObject createAndAddNewWaitObject(int emailCount) {
        int existingCount = this.imapHostManager.getAllMessages().size();
        if (existingCount >= emailCount) {
            return null;
        }
        WaitObject ret = new WaitObject(emailCount - existingCount);
        this.notifyList.add(ret);
        return ret;
    }

    private class Incoming {
        private Incoming() {
        }

        public void enqueue(MovingMessage msg) {
            for (MailAddress address : msg.getToAddresses()) {
                this.handle(msg, address);
            }
        }

        private void handle(MovingMessage msg, MailAddress mailAddress) {
            try {
                GreenMailUser user = SmtpManager.this.userManager.getUserByEmail(mailAddress.getEmail());
                if (null == user) {
                    String login = mailAddress.getEmail();
                    String email = mailAddress.getEmail();
                    String password = mailAddress.getEmail();
                    user = SmtpManager.this.userManager.createUser(email, login, password);
                    log.info("Created user login {} for address {} with password {} because it didn't exist before.", new Object[]{login, email, password});
                }
                user.deliver(msg);
            }
            catch (Exception e) {
                log.error("Can not deliver message " + msg + " to " + mailAddress, (Throwable)e);
                throw new RuntimeException(e);
            }
            msg.releaseContent();
        }
    }

    public static class WaitObject {
        private boolean arrived = false;
        private int emailCount;

        public WaitObject(int emailCount) {
            this.emailCount = emailCount;
        }

        public int getEmailCount() {
            return this.emailCount;
        }

        public boolean isArrived() {
            return this.arrived;
        }

        private void setArrived() {
            this.arrived = true;
        }

        public void emailReceived() {
            --this.emailCount;
            if (this.emailCount <= 0) {
                this.setArrived();
                this.notifyAll();
            }
        }
    }
}

