/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.Store;
import com.icegreen.greenmail.store.StoredMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Quota;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;

public class InMemoryStore
implements Store,
ImapConstants {
    private RootFolder rootMailbox = new RootFolder();
    private static final Flags PERMANENT_FLAGS = new Flags();
    boolean quotaSupported = true;
    private Map<String, Set<Quota>> quotaMap = new HashMap<String, Set<Quota>>();

    @Override
    public MailFolder getMailbox(String absoluteMailboxName) {
        String childName;
        HierarchicalFolder parent;
        StringTokenizer tokens = new StringTokenizer(absoluteMailboxName, HIERARCHY_DELIMITER);
        if (!tokens.hasMoreTokens() || !tokens.nextToken().equalsIgnoreCase("#mail")) {
            return null;
        }
        for (parent = this.rootMailbox; parent != null && tokens.hasMoreTokens(); parent = parent.getChild(childName)) {
            childName = tokens.nextToken();
        }
        return parent;
    }

    @Override
    public MailFolder getMailbox(MailFolder parent, String name) {
        return ((HierarchicalFolder)parent).getChild(name);
    }

    @Override
    public MailFolder createMailbox(MailFolder parent, String mailboxName, boolean selectable) throws FolderException {
        if (mailboxName.indexOf(46) != -1) {
            throw new FolderException("Invalid mailbox name.");
        }
        HierarchicalFolder castParent = (HierarchicalFolder)parent;
        HierarchicalFolder child = new HierarchicalFolder(castParent, mailboxName);
        castParent.getChildren().add(child);
        child.setSelectable(selectable);
        return child;
    }

    @Override
    public void deleteMailbox(MailFolder folder) throws FolderException {
        HierarchicalFolder toDelete = (HierarchicalFolder)folder;
        if (!toDelete.getChildren().isEmpty()) {
            throw new FolderException("Cannot delete mailbox with children.");
        }
        if (toDelete.getMessageCount() != 0) {
            throw new FolderException("Cannot delete non-empty mailbox");
        }
        HierarchicalFolder parent = toDelete.getParent();
        parent.getChildren().remove(toDelete);
    }

    @Override
    public void renameMailbox(MailFolder existingFolder, String newName) throws FolderException {
        String newFolderPathWithoutName;
        String newFolderName;
        HierarchicalFolder toRename = (HierarchicalFolder)existingFolder;
        HierarchicalFolder parent = toRename.getParent();
        int idx = newName.lastIndexOf(46);
        if (idx > 0) {
            newFolderName = newName.substring(idx + 1);
            newFolderPathWithoutName = newName.substring(0, idx);
        } else {
            newFolderName = newName;
            newFolderPathWithoutName = "";
        }
        if (parent.getName().equals(newFolderPathWithoutName)) {
            toRename.setName(newFolderName);
        } else {
            parent.getChildren().remove(toRename);
            HierarchicalFolder userFolder = this.findParentByName(toRename, "INBOX").getParent();
            String[] path = newName.split('\\' + ImapConstants.HIERARCHY_DELIMITER);
            HierarchicalFolder newParent = userFolder;
            for (int i = 0; i < path.length - 1; ++i) {
                newParent = newParent.getChild(path[i]);
            }
            toRename.moveToNewParent(newParent);
            toRename.setName(newFolderName);
        }
    }

    private HierarchicalFolder findParentByName(HierarchicalFolder folder, String parentName) {
        HierarchicalFolder currentFolder;
        for (currentFolder = folder; null != currentFolder && !parentName.equals(currentFolder.getName()); currentFolder = currentFolder.getParent()) {
        }
        return currentFolder;
    }

    @Override
    public Collection<MailFolder> getChildren(MailFolder parent) {
        Collection<HierarchicalFolder> children = ((HierarchicalFolder)parent).getChildren();
        return Collections.unmodifiableCollection(children);
    }

    @Override
    public MailFolder setSelectable(MailFolder folder, boolean selectable) {
        ((HierarchicalFolder)folder).setSelectable(selectable);
        return folder;
    }

    @Override
    public Collection<MailFolder> listMailboxes(String searchPattern) throws FolderException {
        int starIndex = searchPattern.indexOf(42);
        int percentIndex = searchPattern.indexOf(37);
        if (starIndex > -1 && starIndex < searchPattern.length() - 1 || percentIndex > -1 && percentIndex < searchPattern.length() - 1) {
            throw new FolderException("WIldcard characters are only handled as the last character of a list argument.");
        }
        ArrayList<MailFolder> mailboxes = new ArrayList<MailFolder>();
        if (starIndex != -1 || percentIndex != -1) {
            int lastDot = searchPattern.lastIndexOf(HIERARCHY_DELIMITER);
            String parentName = lastDot < 0 ? "#mail" : searchPattern.substring(0, lastDot);
            String matchPattern = searchPattern.substring(lastDot + 1, searchPattern.length() - 1);
            HierarchicalFolder parent = (HierarchicalFolder)this.getMailbox(parentName);
            if (parent != null) {
                for (HierarchicalFolder o : parent.getChildren()) {
                    HierarchicalFolder child = o;
                    if (!child.getName().startsWith(matchPattern)) continue;
                    mailboxes.add(child);
                    if (starIndex == -1) continue;
                    this.addAllChildren(child, mailboxes);
                }
            }
        } else {
            MailFolder folder = this.getMailbox(searchPattern);
            if (folder != null) {
                mailboxes.add(folder);
            }
        }
        return mailboxes;
    }

    @Override
    public Quota[] getQuota(String root, String qualifiedRootPrefix) {
        HashSet<String> rootPaths = new HashSet<String>();
        if (!root.contains(ImapConstants.HIERARCHY_DELIMITER)) {
            rootPaths.add(qualifiedRootPrefix + root);
        } else {
            for (String r : root.split(ImapConstants.HIERARCHY_DELIMITER)) {
                rootPaths.add(qualifiedRootPrefix + r);
            }
        }
        rootPaths.add(qualifiedRootPrefix);
        HashSet<Quota> collectedQuotas = new HashSet<Quota>();
        for (String p : rootPaths) {
            Set<Quota> quotas = this.quotaMap.get(p);
            if (null == quotas) continue;
            collectedQuotas.addAll(quotas);
        }
        this.updateQuotas(collectedQuotas, qualifiedRootPrefix);
        return collectedQuotas.toArray(new Quota[collectedQuotas.size()]);
    }

    private void updateQuotas(Set<Quota> quotas, String qualifiedRootPrefix) {
        for (Quota q : quotas) {
            this.updateQuota(q, qualifiedRootPrefix);
        }
    }

    private void updateQuota(Quota quota, String pQualifiedRootPrefix) {
        MailFolder folder = this.getMailbox("#mail" + ImapConstants.HIERARCHY_DELIMITER + pQualifiedRootPrefix + ImapConstants.HIERARCHY_DELIMITER + quota.quotaRoot);
        try {
            for (Quota.Resource r : quota.resources) {
                if ("STORAGE".equals(r.name)) {
                    long size = 0L;
                    for (StoredMessage m : folder.getMessages()) {
                        size += (long)m.getMimeMessage().getSize();
                    }
                    r.usage = size;
                    continue;
                }
                if ("MESSAGES".equals(r.name)) {
                    r.usage = folder.getMessageCount();
                    continue;
                }
                throw new IllegalStateException("Quota " + r.name + " not supported");
            }
        }
        catch (MessagingException ex) {
            throw new IllegalStateException("Can not update/verify quota " + quota, ex);
        }
    }

    @Override
    public void setQuota(Quota quota, String qualifiedRootPrefix) {
        for (Quota.Resource r : quota.resources) {
            if ("STORAGE".equals(r.name) || "MESSAGES".equals(r.name)) continue;
            throw new IllegalStateException("Quota " + r.name + " not supported");
        }
        Set<Quota> quotas = this.quotaMap.get(qualifiedRootPrefix + quota.quotaRoot);
        if (null == quotas) {
            quotas = new HashSet<Quota>();
            this.quotaMap.put(qualifiedRootPrefix + quota.quotaRoot, quotas);
        } else {
            quotas.clear();
        }
        quotas.add(quota);
    }

    private void addAllChildren(HierarchicalFolder mailbox, Collection<MailFolder> mailboxes) {
        Collection<HierarchicalFolder> children = mailbox.getChildren();
        Iterator<HierarchicalFolder> i$ = children.iterator();
        while (i$.hasNext()) {
            HierarchicalFolder aChildren;
            HierarchicalFolder child = aChildren = i$.next();
            mailboxes.add(child);
            this.addAllChildren(child, mailboxes);
        }
    }

    @Override
    public boolean isQuotaSupported() {
        return this.quotaSupported;
    }

    @Override
    public void setQuotaSupported(boolean pQuotaSupported) {
        this.quotaSupported = pQuotaSupported;
    }

    static {
        PERMANENT_FLAGS.add(Flags.Flag.ANSWERED);
        PERMANENT_FLAGS.add(Flags.Flag.DELETED);
        PERMANENT_FLAGS.add(Flags.Flag.DRAFT);
        PERMANENT_FLAGS.add(Flags.Flag.FLAGGED);
        PERMANENT_FLAGS.add(Flags.Flag.SEEN);
    }

    private class HierarchicalFolder
    implements MailFolder,
    UIDFolder {
        private Collection<HierarchicalFolder> children;
        private HierarchicalFolder parent;
        protected String name;
        private boolean isSelectable = false;
        private final List<StoredMessage> mailMessages = Collections.synchronizedList(new ArrayList());
        private long nextUid = 1L;
        private long uidValidity;
        private final List<FolderListener> _mailboxListeners = Collections.synchronizedList(new ArrayList());

        public HierarchicalFolder(HierarchicalFolder parent, String name) {
            this.name = name;
            this.children = new ArrayList<HierarchicalFolder>();
            this.parent = parent;
            this.uidValidity = System.currentTimeMillis();
        }

        public Collection<HierarchicalFolder> getChildren() {
            return this.children;
        }

        public HierarchicalFolder getParent() {
            return this.parent;
        }

        public void moveToNewParent(HierarchicalFolder newParent) {
            if (!newParent.getChildren().contains(this)) {
                this.parent = newParent;
                this.parent.getChildren().add(this);
            }
        }

        public HierarchicalFolder getChild(String name) {
            for (HierarchicalFolder child : this.children) {
                if (!child.getName().equalsIgnoreCase(name)) continue;
                return child;
            }
            return null;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.parent.getFullName() + '.' + this.name;
        }

        @Override
        public Flags getPermanentFlags() {
            return PERMANENT_FLAGS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getMessageCount() {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                return this.mailMessages.size();
            }
        }

        @Override
        public long getUidValidity() {
            return this.uidValidity;
        }

        @Override
        public long getUidNext() {
            return this.nextUid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getUnseenCount() {
            int count = 0;
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (StoredMessage message : this.mailMessages) {
                    if (message.isSet(Flags.Flag.SEEN)) continue;
                    ++count;
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getFirstUnseen() {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (int i = 0; i < this.mailMessages.size(); ++i) {
                    StoredMessage message = this.mailMessages.get(i);
                    if (message.isSet(Flags.Flag.SEEN)) continue;
                    return i + 1;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getRecentCount(boolean reset) {
            int count = 0;
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (StoredMessage message : this.mailMessages) {
                    if (!message.isSet(Flags.Flag.RECENT)) continue;
                    ++count;
                    if (!reset) continue;
                    message.setFlag(Flags.Flag.RECENT, false);
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getMsn(long uid) throws FolderException {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (int i = 0; i < this.mailMessages.size(); ++i) {
                    StoredMessage message = this.mailMessages.get(i);
                    if (message.getUid() != uid) continue;
                    return i + 1;
                }
            }
            throw new FolderException("No such message.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signalDeletion() {
            List<FolderListener> list = this._mailboxListeners;
            synchronized (list) {
                for (FolderListener listener : this._mailboxListeners) {
                    listener.mailboxDeleted();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List getMessages(MsgRangeFilter range) {
            ArrayList<StoredMessage> ret = new ArrayList<StoredMessage>();
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (int i = 0; i < this.mailMessages.size(); ++i) {
                    if (!range.includes(i + 1)) continue;
                    ret.add(this.mailMessages.get(i));
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StoredMessage> getMessages() {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                return new ArrayList<StoredMessage>(this.mailMessages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StoredMessage> getNonDeletedMessages() {
            ArrayList<StoredMessage> ret = new ArrayList<StoredMessage>();
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (StoredMessage mailMessage : this.mailMessages) {
                    if (mailMessage.getFlags().contains(Flags.Flag.DELETED)) continue;
                    ret.add(mailMessage);
                }
            }
            return ret;
        }

        @Override
        public boolean isSelectable() {
            return this.isSelectable;
        }

        public void setSelectable(boolean selectable) {
            this.isSelectable = selectable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long appendMessage(MimeMessage message, Flags flags, Date receivedDate) {
            int newMsn;
            long uid = this.nextUid++;
            try {
                message.setFlags(flags, true);
                message.setFlag(Flags.Flag.RECENT, true);
            }
            catch (MessagingException e) {
                throw new IllegalStateException("Can not set flags", e);
            }
            StoredMessage storedMessage = new StoredMessage(message, receivedDate, uid);
            List<Object> list = this.mailMessages;
            synchronized (list) {
                this.mailMessages.add(storedMessage);
                newMsn = this.mailMessages.size();
            }
            list = this._mailboxListeners;
            synchronized (list) {
                for (FolderListener _mailboxListener : this._mailboxListeners) {
                    _mailboxListener.added(newMsn);
                }
            }
            return uid;
        }

        @Override
        public void setFlags(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
            int msn = this.getMsn(uid);
            StoredMessage message = this.mailMessages.get(msn - 1);
            message.setFlags(flags, value);
            Long uidNotification = null;
            if (addUid) {
                uidNotification = uid;
            }
            this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
        }

        @Override
        public void replaceFlags(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
            int msn = this.getMsn(uid);
            StoredMessage message = this.mailMessages.get(msn - 1);
            message.setFlags(MessageFlags.ALL_FLAGS, false);
            message.setFlags(flags, true);
            Long uidNotification = null;
            if (addUid) {
                uidNotification = uid;
            }
            this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyFlagUpdate(int msn, Flags flags, Long uidNotification, FolderListener silentListener) {
            List<FolderListener> list = this._mailboxListeners;
            synchronized (list) {
                for (FolderListener listener : this._mailboxListeners) {
                    if (listener == silentListener) continue;
                    listener.flagsUpdated(msn, flags, uidNotification);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteAllMessages() {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                this.mailMessages.clear();
            }
        }

        @Override
        public void store(MovingMessage mail) throws Exception {
            this.store(mail.getMessage());
        }

        @Override
        public void store(MimeMessage message) throws Exception {
            Date receivedDate = new Date();
            Flags flags = new Flags();
            this.appendMessage(message, flags, receivedDate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StoredMessage getMessage(long uid) {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (StoredMessage mailMessage : this.mailMessages) {
                    if (mailMessage.getUid() != uid) continue;
                    return mailMessage;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long[] getMessageUids() {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                long[] uids = new long[this.mailMessages.size()];
                for (int i = 0; i < this.mailMessages.size(); ++i) {
                    StoredMessage message = this.mailMessages.get(i);
                    uids[i] = message.getUid();
                }
                return uids;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteMessage(int msn) {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                this.mailMessages.remove(msn - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long[] search(SearchTerm searchTerm) {
            ArrayList<StoredMessage> matchedMessages = new ArrayList<StoredMessage>();
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (StoredMessage mailMessage : this.mailMessages) {
                    if (!searchTerm.match((Message)mailMessage.getMimeMessage())) continue;
                    matchedMessages.add(mailMessage);
                }
            }
            long[] matchedUids = new long[matchedMessages.size()];
            for (int i = 0; i < matchedUids.length; ++i) {
                long uid;
                StoredMessage storedMessage = (StoredMessage)matchedMessages.get(i);
                matchedUids[i] = uid = storedMessage.getUid();
            }
            return matchedUids;
        }

        @Override
        public void copyMessage(long uid, MailFolder toFolder) throws FolderException {
            MimeMessage newMime;
            StoredMessage originalMessage = this.getMessage(uid);
            try {
                newMime = new MimeMessage(originalMessage.getMimeMessage());
            }
            catch (MessagingException e) {
                throw new FolderException("Can not copy message " + uid + " to folder " + toFolder, (Exception)((Object)e));
            }
            toFolder.appendMessage(newMime, originalMessage.getFlags(), originalMessage.getReceivedDate());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void expunge() throws FolderException {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (int i = this.mailMessages.size() - 1; i >= 0; --i) {
                    StoredMessage message = this.mailMessages.get(i);
                    if (!message.isSet(Flags.Flag.DELETED)) continue;
                    this.expungeMessage(i + 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expungeMessage(int msn) {
            List<FolderListener> list = this._mailboxListeners;
            synchronized (list) {
                this.deleteMessage(msn);
                for (FolderListener expungeListener : this._mailboxListeners) {
                    expungeListener.expunged(msn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(FolderListener listener) {
            List<FolderListener> list = this._mailboxListeners;
            synchronized (list) {
                this._mailboxListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(FolderListener listener) {
            List<FolderListener> list = this._mailboxListeners;
            synchronized (list) {
                this._mailboxListeners.remove(listener);
            }
        }

        public String toString() {
            return "HierarchicalFolder{name='" + this.name + '\'' + ", parent=" + this.parent + ", isSelectable=" + this.isSelectable + '}';
        }

        public long getUIDValidity() throws MessagingException {
            return this.getUidValidity();
        }

        public Message getMessageByUID(long uid) throws MessagingException {
            return this.getMessage(uid).getMimeMessage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message[] getMessagesByUID(long start, long end) throws MessagingException {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                ArrayList<MimeMessage> messages = new ArrayList<MimeMessage>();
                for (StoredMessage mailMessage : this.mailMessages) {
                    long uid = mailMessage.getUid();
                    if (uid < start || uid > end) continue;
                    messages.add(mailMessage.getMimeMessage());
                }
                return messages.toArray(new Message[messages.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message[] getMessagesByUID(long[] uids) throws MessagingException {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                ArrayList<MimeMessage> messages = new ArrayList<MimeMessage>(uids.length);
                HashMap<Long, StoredMessage> uid2Msg = new HashMap<Long, StoredMessage>(this.mailMessages.size());
                for (StoredMessage mailMessage : this.mailMessages) {
                    uid2Msg.put(mailMessage.getUid(), mailMessage);
                }
                for (long uid : uids) {
                    StoredMessage storedMessage = (StoredMessage)uid2Msg.get(uid);
                    if (storedMessage == null) continue;
                    messages.add(storedMessage.getMimeMessage());
                }
                return messages.toArray(new Message[messages.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getUID(Message message) throws MessagingException {
            List<StoredMessage> list = this.mailMessages;
            synchronized (list) {
                for (StoredMessage mailMessage : this.mailMessages) {
                    if (mailMessage.getMimeMessage() != message) continue;
                    return mailMessage.getUid();
                }
            }
            throw new IllegalStateException("No match found for " + message);
        }
    }

    private class RootFolder
    extends HierarchicalFolder {
        public RootFolder() {
            super(null, "#mail");
        }

        @Override
        public String getFullName() {
            return this.name;
        }
    }
}

