/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class UserManager {
    private Map<String, GreenMailUser> loginToUser = Collections.synchronizedMap(new HashMap());
    private Map<String, GreenMailUser> emailToUser = Collections.synchronizedMap(new HashMap());
    private ImapHostManager imapHostManager;

    public UserManager(ImapHostManager imapHostManager) {
        this.imapHostManager = imapHostManager;
    }

    public GreenMailUser getUser(String login) {
        return this.loginToUser.get(UserManager.normalizerUserName(login));
    }

    public GreenMailUser getUserByEmail(String email) {
        return this.emailToUser.get(UserManager.normalizerUserName(email));
    }

    public GreenMailUser createUser(String email, String login, String password) throws UserException {
        UserImpl user = new UserImpl(email, login, password, this.imapHostManager);
        user.create();
        this.addUser(user);
        return user;
    }

    public void addUser(GreenMailUser user) {
        this.deleteUser(user);
        this.loginToUser.put(UserManager.normalizerUserName(user.getLogin()), user);
        this.emailToUser.put(UserManager.normalizerUserName(user.getEmail()), user);
    }

    public void deleteUser(GreenMailUser user) {
        GreenMailUser deletedUser = this.loginToUser.remove(UserManager.normalizerUserName(user.getLogin()));
        if (deletedUser != null) {
            this.emailToUser.remove(UserManager.normalizerUserName(deletedUser.getEmail()));
            deletedUser.delete();
        }
    }

    public Collection<GreenMailUser> listUser() {
        return Collections.unmodifiableCollection(this.loginToUser.values());
    }

    public boolean test(String userid, String password) {
        GreenMailUser u = this.getUser(userid);
        return null != u && u.getPassword().equals(password);
    }

    public ImapHostManager getImapHostManager() {
        return this.imapHostManager;
    }

    private static String normalizerUserName(String login) {
        return login.trim().toLowerCase(Locale.ENGLISH);
    }
}

