/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.server.AbstractServer;
import com.icegreen.greenmail.util.DummySSLSocketFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;

public class Retriever {
    private String protocol;
    private int port;
    private String host;
    private Store store = null;

    public Retriever(AbstractServer server) {
        this.protocol = server.getProtocol();
        this.port = server.getPort();
        this.host = server.getBindTo();
    }

    public Message[] getMessages(String account) {
        return this.getMessages(account, account);
    }

    public Message[] getMessages(String account, String password) {
        Properties props = new Properties();
        if (this.protocol.endsWith("s")) {
            props.put("mail.pop3.starttls.enable", Boolean.TRUE);
            props.put("mail.imap.starttls.enable", Boolean.TRUE);
        }
        props.setProperty("mail.imaps.socketFactory.class", DummySSLSocketFactory.class.getName());
        props.setProperty("mail.pop3s.socketFactory.class", DummySSLSocketFactory.class.getName());
        props.setProperty("mail.imap.socketFactory.fallback", "false");
        props.setProperty("mail.imaps.socketFactory.fallback", "false");
        props.setProperty("mail.pop3s.socketFactory.fallback", "false");
        String timeout = "15000";
        props.setProperty("mail.imap.connectiontimeout", "15000");
        props.setProperty("mail.imaps.connectiontimeout", "15000");
        props.setProperty("mail.pop3.connectiontimeout", "15000");
        props.setProperty("mail.pop3s.connectiontimeout", "15000");
        props.setProperty("mail.imap.timeout", "15000");
        props.setProperty("mail.imaps.timeout", "15000");
        props.setProperty("mail.pop3.timeout", "15000");
        props.setProperty("mail.pop3s.timeout", "15000");
        Session session = Session.getInstance((Properties)props, null);
        try {
            this.store = session.getStore(this.protocol);
            this.store.connect(this.host, this.port, account, password);
            Folder rootFolder = this.store.getFolder("INBOX");
            List<Message> messages = this.getMessages(rootFolder);
            FetchProfile fp = new FetchProfile();
            fp.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
            rootFolder.fetch(rootFolder.getMessages(), fp);
            return messages.toArray(new Message[messages.size()]);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void logout() {
        try {
            this.store.close();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Message> getMessages(Folder folder) throws MessagingException {
        ArrayList<Message> ret = new ArrayList<Message>();
        if ((folder.getType() & 1) != 0) {
            if (!folder.isOpen()) {
                folder.open(1);
            }
            Message[] messages = folder.getMessages();
            Collections.addAll(ret, messages);
        }
        if ((folder.getType() & 2) != 0) {
            Folder[] f;
            for (Folder aF : f = folder.list()) {
                ret.addAll(this.getMessages(aF));
            }
        }
        return ret;
    }
}

