/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

public class ServerSetup {
    public static final String PROTOCOL_SMTP = "smtp";
    public static final String PROTOCOL_SMTPS = "smtps";
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_POP3S = "pop3s";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_IMAPS = "imaps";
    public static final int PORT_SMTP = 25;
    public static final int PORT_SMTPS = 465;
    public static final int PORT_POP3 = 110;
    public static final int PORT_POP3S = 995;
    public static final int PORT_IMAP = 143;
    public static final int PORT_IMAPS = 993;
    public static final ServerSetup SMTP = new ServerSetup(25, null, "smtp");
    public static final ServerSetup SMTPS = new ServerSetup(465, null, "smtps");
    public static final ServerSetup POP3 = new ServerSetup(110, null, "pop3");
    public static final ServerSetup POP3S = new ServerSetup(995, null, "pop3s");
    public static final ServerSetup IMAP = new ServerSetup(143, null, "imap");
    public static final ServerSetup IMAPS = new ServerSetup(993, null, "imaps");
    public static final ServerSetup[] SMTP_POP3 = new ServerSetup[]{SMTP, POP3};
    public static final ServerSetup[] SMTP_IMAP = new ServerSetup[]{SMTP, IMAP};
    public static final ServerSetup[] SMTP_POP3_IMAP = new ServerSetup[]{SMTP, POP3, IMAP};
    public static final ServerSetup[] SMTPS_POP3S = new ServerSetup[]{SMTPS, POP3S};
    public static final ServerSetup[] SMTPS_POP3S_IMAPS = new ServerSetup[]{SMTPS, POP3S, IMAPS};
    public static final ServerSetup[] SMTPS_IMAPS = new ServerSetup[]{SMTPS, IMAPS};
    public static final ServerSetup[] ALL = new ServerSetup[]{SMTP, SMTPS, POP3, POP3S, IMAP, IMAPS};
    private final int port;
    private final String bindAddress;
    private final String protocol;

    public ServerSetup(int port, String bindAddress, String protocol) {
        this.port = port;
        this.bindAddress = null == bindAddress || bindAddress.length() == 0 ? ServerSetup.getLocalHostAddress() : bindAddress;
        this.protocol = protocol;
    }

    public static String getLocalHostAddress() {
        return "127.0.0.1";
    }

    public boolean isSecure() {
        return this.protocol.endsWith("s");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getPort() {
        return this.port;
    }
}

