/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionState;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CommandTemplate
implements ImapCommand,
ImapConstants {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected CommandParser parser = new CommandParser();
    private String name;
    private String argSyntax;

    CommandTemplate(String name, String argSyntax) {
        this.name = name;
        this.argSyntax = argSyntax;
    }

    @Override
    public boolean validForState(ImapSessionState state) {
        return true;
    }

    @Override
    public void process(ImapRequestLineReader request, ImapResponse response, ImapSession session) {
        try {
            this.doProcess(request, response, session);
        }
        catch (FolderException e) {
            this.log.warn("Error processing command", (Throwable)e);
            response.commandFailed(this, e.getResponseCode(), e.getMessage());
        }
        catch (AuthorizationException e) {
            this.log.warn("Error processing command due to authentication", (Throwable)e);
            String msg = "Authorization error: Lacking permissions to perform requested operation.";
            response.commandFailed(this, msg);
        }
        catch (ProtocolException e) {
            String msg = e.getMessage() + " Command should be '" + this.getExpectedMessage() + '\'';
            this.log.warn("Error processing command: " + msg, (Throwable)e);
            response.commandError(msg);
        }
    }

    protected abstract void doProcess(ImapRequestLineReader var1, ImapResponse var2, ImapSession var3) throws ProtocolException, FolderException, AuthorizationException;

    protected String getExpectedMessage() {
        StringBuilder syntax = new StringBuilder("<tag> ");
        syntax.append(this.getName());
        String args = this.getArgSyntax();
        if (args != null && args.length() > 0) {
            syntax.append(' ');
            syntax.append(args);
        }
        return syntax.toString();
    }

    protected final String getArgSyntax() {
        return this.argSyntax;
    }

    protected MailFolder getMailbox(String mailboxName, ImapSession session, boolean mustExist) throws FolderException {
        return session.getHost().getFolder(session.getUser(), mailboxName, mustExist);
    }

    public CommandParser getParser() {
        return this.parser;
    }

    @Override
    public final String getName() {
        return this.name;
    }
}

