/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.DummySSLSocketFactory;
import java.util.Map;
import java.util.Properties;

public class ServerSetup {
    public static final String PROTOCOL_SMTP = "smtp";
    public static final String PROTOCOL_SMTPS = "smtps";
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_POP3S = "pop3s";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_IMAPS = "imaps";
    public static final String[] PROTOCOLS = new String[]{"smtp", "smtps", "imap", "imaps", "pop3", "pop3s"};
    public static final int PORT_SMTP = 25;
    public static final int PORT_SMTPS = 465;
    public static final int PORT_POP3 = 110;
    public static final int PORT_POP3S = 995;
    public static final int PORT_IMAP = 143;
    public static final int PORT_IMAPS = 993;
    public static final ServerSetup SMTP = new ServerSetup(25, null, "smtp");
    public static final ServerSetup SMTPS = new ServerSetup(465, null, "smtps");
    public static final ServerSetup POP3 = new ServerSetup(110, null, "pop3");
    public static final ServerSetup POP3S = new ServerSetup(995, null, "pop3s");
    public static final ServerSetup IMAP = new ServerSetup(143, null, "imap");
    public static final ServerSetup IMAPS = new ServerSetup(993, null, "imaps");
    public static final ServerSetup[] SMTP_POP3 = new ServerSetup[]{SMTP, POP3};
    public static final ServerSetup[] SMTP_IMAP = new ServerSetup[]{SMTP, IMAP};
    public static final ServerSetup[] SMTP_POP3_IMAP = new ServerSetup[]{SMTP, POP3, IMAP};
    public static final ServerSetup[] SMTPS_POP3S = new ServerSetup[]{SMTPS, POP3S};
    public static final ServerSetup[] SMTPS_POP3S_IMAPS = new ServerSetup[]{SMTPS, POP3S, IMAPS};
    public static final ServerSetup[] SMTPS_IMAPS = new ServerSetup[]{SMTPS, IMAPS};
    public static final ServerSetup[] ALL = new ServerSetup[]{SMTP, SMTPS, POP3, POP3S, IMAP, IMAPS};
    public static final long READ_TIMEOUT = 15000L;
    public static final long CONNECTION_TIMEOUT = 15000L;
    private final int port;
    private final String bindAddress;
    private final String protocol;
    private long readTimeout = -1L;
    private long connectionTimeout = -1L;
    private long writeTimeout = -1L;
    private long serverStartupTimeout = 1000L;

    public ServerSetup(int port, String bindAddress, String protocol) {
        this.port = port;
        this.bindAddress = null == bindAddress || bindAddress.length() == 0 ? ServerSetup.getLocalHostAddress() : bindAddress;
        this.protocol = protocol;
    }

    public static String getLocalHostAddress() {
        return "127.0.0.1";
    }

    public String getDefaultBindAddress() {
        return "0.0.0.0";
    }

    public boolean isSecure() {
        return this.protocol.endsWith("s");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public long getServerStartupTimeout() {
        return this.serverStartupTimeout;
    }

    public void setServerStartupTimeout(long timeoutInMs) {
        this.serverStartupTimeout = timeoutInMs;
    }

    public Properties configureJavaMailSessionProperties(Properties properties, boolean debug) {
        Properties props = new Properties();
        if (debug) {
            props.setProperty("mail.debug", "true");
        }
        props.setProperty("mail." + this.getProtocol() + ".localaddress", String.valueOf(ServerSetup.getLocalHostAddress()));
        props.setProperty("mail." + this.getProtocol() + ".port", String.valueOf(this.getPort()));
        props.setProperty("mail." + this.getProtocol() + ".host", String.valueOf(this.getBindAddress()));
        if (this.isSecure()) {
            props.put("mail." + this.getProtocol() + ".starttls.enable", Boolean.TRUE);
            props.setProperty("mail." + this.getProtocol() + ".socketFactory.class", DummySSLSocketFactory.class.getName());
            props.setProperty("mail." + this.getProtocol() + ".socketFactory.fallback", "false");
        }
        props.setProperty("mail." + this.getProtocol() + ".connectiontimeout", Long.toString(this.getConnectionTimeout() < 0L ? 15000L : this.getConnectionTimeout()));
        props.setProperty("mail." + this.getProtocol() + ".timeout", Long.toString(this.getReadTimeout() < 0L ? 15000L : this.getReadTimeout()));
        if (this.getWriteTimeout() >= 0L) {
            props.setProperty("mail." + this.getProtocol() + ".writetimeout", Long.toString(this.getWriteTimeout()));
        }
        if (this.getProtocol().startsWith(PROTOCOL_SMTP)) {
            props.setProperty("mail.transport.protocol", this.getProtocol());
            props.setProperty("mail.transport.protocol.rfc822", this.getProtocol());
        }
        props.setProperty("mail.store.protocol", this.getProtocol());
        if (null != properties && !properties.isEmpty()) {
            props.putAll((Map<?, ?>)properties);
        }
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerSetup)) {
            return false;
        }
        ServerSetup that = (ServerSetup)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.readTimeout != that.readTimeout) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.writeTimeout != that.writeTimeout) {
            return false;
        }
        if (this.serverStartupTimeout != that.serverStartupTimeout) {
            return false;
        }
        if (this.bindAddress != null ? !this.bindAddress.equals(that.bindAddress) : that.bindAddress != null) {
            return false;
        }
        return !(this.protocol == null ? that.protocol != null : !this.protocol.equals(that.protocol));
    }

    public int hashCode() {
        int result = this.port;
        result = 31 * result + (this.bindAddress != null ? this.bindAddress.hashCode() : 0);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (int)(this.readTimeout ^ this.readTimeout >>> 32);
        result = 31 * result + (int)(this.connectionTimeout ^ this.connectionTimeout >>> 32);
        result = 31 * result + (int)(this.writeTimeout ^ this.writeTimeout >>> 32);
        result = 31 * result + (int)(this.serverStartupTimeout ^ this.serverStartupTimeout >>> 32);
        return result;
    }

    public String toString() {
        return "ServerSetup{port=" + this.port + ", bindAddress='" + this.bindAddress + '\'' + ", protocol='" + this.protocol + '\'' + ", readTimeout=" + this.readTimeout + ", connectionTimeout=" + this.connectionTimeout + ", writeTimeout=" + this.writeTimeout + ", serverStartupTimeout=" + this.serverStartupTimeout + '}';
    }

    public ServerSetup createCopy() {
        return this.createCopy(this.getBindAddress());
    }

    public ServerSetup createCopy(String bindAddress) {
        ServerSetup setup = new ServerSetup(this.getPort(), bindAddress, this.getProtocol());
        setup.setServerStartupTimeout(this.getServerStartupTimeout());
        setup.setConnectionTimeout(this.getConnectionTimeout());
        setup.setReadTimeout(this.getReadTimeout());
        setup.setWriteTimeout(this.getWriteTimeout());
        return setup;
    }
}

