/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SearchKey;
import com.icegreen.greenmail.imap.commands.SearchTermBuilder;
import javax.mail.search.AndTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchCommandParser
extends CommandParser {
    private final Logger log = LoggerFactory.getLogger(SearchCommandParser.class);

    SearchCommandParser() {
    }

    public SearchTerm searchTerm(ImapRequestLineReader request) throws ProtocolException {
        SearchTerm resultTerm = null;
        SearchTermBuilder b = null;
        boolean negated = false;
        char next = request.nextChar();
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        while (next != '\n') {
            block14: {
                if (next != '\"' && (quoted || next != '\"' && next != ' ' && next != '\r')) {
                    sb.append(next);
                }
                request.consume();
                next = request.nextChar();
                if (next == '\"' && (quoted = !quoted) || quoted || next != ' ' && next != '\n' || sb.length() <= 0) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Search request is '" + sb.toString() + '\'');
                }
                if (null == b) {
                    try {
                        String keyValue = sb.toString();
                        if (keyValue.charAt(0) == '(' && keyValue.charAt(keyValue.length() - 1) == ')') {
                            keyValue = keyValue.substring(1, keyValue.length() - 1);
                        }
                        if (IdRange.SEQUENCE.matcher(keyValue).matches()) {
                            b = SearchTermBuilder.create(SearchKey.SEQUENCE_SET);
                            next = request.nextChar();
                            while (next == ' ' || next >= '0' && next <= '9' || next == ':') {
                                request.consume();
                                sb.append(next);
                                next = request.nextChar();
                            }
                            b.addParameter(sb.toString());
                            break block14;
                        }
                        SearchKey key = SearchKey.valueOf(keyValue);
                        if (SearchKey.NOT == key) {
                            negated = true;
                            break block14;
                        }
                        b = SearchTermBuilder.create(key);
                    }
                    catch (IllegalArgumentException ex) {
                        this.log.warn("Ignoring not yet implemented search command '" + sb.toString() + "'", (Throwable)ex);
                        negated = false;
                    }
                } else if (b.expectsParameter()) {
                    b = b.addParameter(sb.toString());
                }
            }
            if (b != null && !b.expectsParameter()) {
                SearchTerm searchTerm = b.build();
                if (negated) {
                    searchTerm = new NotTerm(searchTerm);
                    negated = false;
                }
                b = null;
                resultTerm = resultTerm == null ? searchTerm : new AndTerm(resultTerm, searchTerm);
            }
            sb = new StringBuilder();
            next = request.nextChar();
        }
        return resultTerm;
    }
}

