/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.SearchCommandParser;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import java.nio.charset.CharacterCodingException;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "SEARCH";
    public static final String ARGS = "<search term>";
    private SearchCommandParser parser = new SearchCommandParser();

    SearchCommand() {
        super(NAME, ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        SearchTerm searchTerm = null;
        try {
            searchTerm = this.parser.searchTerm(request);
        }
        catch (IllegalArgumentException ex) {
            response.commandError("Search command not supported");
            return;
        }
        catch (CharacterCodingException e) {
            response.commandError("Search command does not support charset " + e.getMessage());
            return;
        }
        if (null == searchTerm) {
            this.log.warn("Ignoring unsupported search command");
            response.commandComplete(this);
            return;
        }
        this.parser.endLine(request);
        ImapSessionFolder folder = session.getSelected();
        long[] uids = folder.search(searchTerm);
        StringBuilder idList = new StringBuilder();
        for (int i = 0; i < uids.length; ++i) {
            if (i > 0) {
                idList.append(" ");
            }
            long uid = uids[i];
            if (useUids) {
                idList.append(uid);
                continue;
            }
            int msn = folder.getMsn(uid);
            idList.append(msn);
        }
        response.commandResponse(this, idList.toString());
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }
}

