/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SearchKey;
import com.icegreen.greenmail.store.StoredMessage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.RecipientTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SizeTerm;
import javax.mail.search.SubjectTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchTermBuilder {
    private SearchKey key;
    private List<String> parameters = Collections.emptyList();
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchTermBuilder.class);
    public static final AllSearchTerm ALL_SEARCH_TERM = new AllSearchTerm();

    public static SearchTermBuilder create(String pTerm) {
        return SearchTermBuilder.create(SearchKey.valueOf(pTerm));
    }

    public static SearchTermBuilder create(SearchKey key) {
        SearchTermBuilder builder;
        LOGGER.debug("Creating search term for '{}'", (Object)key);
        switch (key) {
            case HEADER: {
                builder = SearchTermBuilder.createHeaderTermBuilder();
                break;
            }
            case ALL: {
                builder = SearchTermBuilder.createSearchTermBuilder(ALL_SEARCH_TERM);
                break;
            }
            case ANSWERED: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("ANSWERED", true);
                break;
            }
            case BCC: {
                builder = SearchTermBuilder.createRecipientSearchTermBuilder(Message.RecipientType.BCC);
                break;
            }
            case CC: {
                builder = SearchTermBuilder.createRecipientSearchTermBuilder(Message.RecipientType.CC);
                break;
            }
            case DELETED: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("DELETED", true);
                break;
            }
            case DRAFT: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("DRAFT", true);
                break;
            }
            case FLAGGED: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("FLAGGED", true);
                break;
            }
            case FROM: {
                builder = SearchTermBuilder.createFromSearchTermBuilder();
                break;
            }
            case NEW: {
                builder = SearchTermBuilder.createSearchTermBuilder((SearchTerm)new AndTerm(SearchTermBuilder.createFlagSearchTerm("RECENT", true), SearchTermBuilder.createFlagSearchTerm("SEEN", false)));
                break;
            }
            case OLD: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("RECENT", false));
                break;
            }
            case RECENT: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("RECENT", true));
                break;
            }
            case SEEN: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("SEEN", true));
                break;
            }
            case SUBJECT: {
                builder = SearchTermBuilder.createSubjectTermBuilder();
                break;
            }
            case BODY: {
                builder = SearchTermBuilder.createBodySearchTermBuilder();
                break;
            }
            case TEXT: {
                builder = SearchTermBuilder.createTextSearchTermBuilder();
                break;
            }
            case TO: {
                builder = SearchTermBuilder.createRecipientSearchTermBuilder(Message.RecipientType.TO);
                break;
            }
            case UID: {
                builder = SearchTermBuilder.createUidTermBuilder();
                break;
            }
            case UNANSWERED: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("ANSWERED", false));
                break;
            }
            case UNDELETED: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("DELETED", false));
                break;
            }
            case UNDRAFT: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("DRAFT", false));
                break;
            }
            case UNFLAGGED: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("FLAGGED", false));
                break;
            }
            case UNSEEN: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("SEEN", false));
                break;
            }
            case KEYWORD: 
            case UNKEYWORD: {
                builder = SearchTermBuilder.createKeywordSearchTermBuilder(key);
                break;
            }
            case SEQUENCE_SET: {
                builder = SearchTermBuilder.createSequenceSetTermBuilder();
                break;
            }
            case OR: {
                builder = SearchTermBuilder.createORTermBuilder();
                break;
            }
            case SINCE: {
                builder = SearchTermBuilder.createReceivedDateTermBuilder(6);
                break;
            }
            case ON: {
                builder = SearchTermBuilder.createReceivedDateTermBuilder(3);
                break;
            }
            case BEFORE: {
                builder = SearchTermBuilder.createReceivedDateTermBuilder(2);
                break;
            }
            case SENTSINCE: {
                builder = SearchTermBuilder.createSentDateTermBuilder(6);
                break;
            }
            case SENTON: {
                builder = SearchTermBuilder.createSentDateTermBuilder(3);
                break;
            }
            case SENTBEFORE: {
                builder = SearchTermBuilder.createSentDateTermBuilder(2);
                break;
            }
            case LARGER: {
                builder = SearchTermBuilder.createMessageSizeTermBuilder(5);
                break;
            }
            case SMALLER: {
                builder = SearchTermBuilder.createMessageSizeTermBuilder(2);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported search term '" + (Object)((Object)key) + '\'');
            }
        }
        builder.setSearchKey(key);
        return builder;
    }

    private static SearchTermBuilder createSentDateTermBuilder(final int searchTerm) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new SentDateTerm(searchTerm, SearchTermBuilder.parseDate(this.getParameters()));
            }
        };
    }

    private static SearchTermBuilder createReceivedDateTermBuilder(final int searchTerm) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new ReceivedDateTerm(searchTerm, SearchTermBuilder.parseDate(this.getParameters()));
            }
        };
    }

    private static SearchTermBuilder createMessageSizeTermBuilder(final int searchTerm) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new SizeTerm(searchTerm, SearchTermBuilder.parseInteger(this.getParameters()));
            }
        };
    }

    private static Date parseDate(List<String> parameters) {
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        String date = parameters.get(0);
        try {
            Date d = df.parse(date);
            LOGGER.debug("Using date '{}'.", (Object)d);
            return d;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse date '" + date + "'", e);
        }
    }

    private static int parseInteger(List<String> parameters) {
        String integer = parameters.get(0);
        try {
            int i = Integer.parseInt(integer);
            LOGGER.debug("Using date '{}'.", (Object)i);
            return i;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to parse integer '" + integer + "'", e);
        }
    }

    private static SearchTermBuilder createORTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new OrTerm((SearchTerm)new SubjectTerm(this.getParameters().get(0)), (SearchTerm)new SubjectTerm(this.getParameters().get(1)));
            }
        };
    }

    private void setSearchKey(SearchKey pKey) {
        this.key = pKey;
    }

    private static SearchTermBuilder createHeaderTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new HeaderTerm(this.getParameters().get(0), this.getParameters().get(1));
            }
        };
    }

    SearchTermBuilder addParameter(String pParameter) {
        if (Collections.emptyList() == this.parameters) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.add(pParameter);
        return this;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getParameter(int pIdx) {
        return this.getParameters().get(pIdx);
    }

    public boolean expectsParameter() {
        return this.parameters.size() < this.key.getNumberOfParameters();
    }

    boolean isCharsetAware() {
        return this.key.isCharsetAware();
    }

    public abstract SearchTerm build();

    private static SearchTermBuilder createSearchTermBuilder(final SearchTerm pSearchTerm) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return pSearchTerm;
            }
        };
    }

    private static SearchTermBuilder createRecipientSearchTermBuilder(final Message.RecipientType type) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                try {
                    return new RecipientTerm(type, (Address)new InternetAddress(this.getParameters().get(0)));
                }
                catch (AddressException e) {
                    throw new IllegalArgumentException("Address is not correct", e);
                }
            }
        };
    }

    private static SearchTermBuilder createBodySearchTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                String query = this.getParameters().get(0);
                return new BodyTerm(query);
            }
        };
    }

    private static SearchTermBuilder createTextSearchTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                String query = this.getParameters().get(0);
                SearchTerm[] terms = new SearchTerm[]{new RecipientStringTerm(Message.RecipientType.TO, query), new RecipientStringTerm(Message.RecipientType.CC, query), new RecipientStringTerm(Message.RecipientType.BCC, query), new FromStringTerm(query), new SubjectTerm(query), new BodyTerm(query)};
                return new OrTerm(terms);
            }
        };
    }

    private static SearchTermBuilder createFromSearchTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                try {
                    return new FromTerm((Address)new InternetAddress(this.getParameters().get(0)));
                }
                catch (AddressException e) {
                    throw new IllegalArgumentException("Address is not correct", e);
                }
            }
        };
    }

    private static SearchTermBuilder createSubjectTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new SubjectTerm(this.getParameters().get(0));
            }
        };
    }

    private static SearchTermBuilder createFlagSearchTermBuilder(final String pFlagName, final boolean pValue) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return SearchTermBuilder.createFlagSearchTerm(pFlagName, pValue);
            }
        };
    }

    private static SearchTermBuilder createKeywordSearchTermBuilder(final SearchKey pKey) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return SearchTermBuilder.createFlagSearchTerm(this.getParameter(0), pKey == SearchKey.KEYWORD);
            }
        };
    }

    private static SearchTerm createFlagSearchTerm(String pFlagName, boolean pValue) {
        Flags.Flag flag = SearchTermBuilder.toFlag(pFlagName);
        Flags flags = new Flags();
        if (null == flag) {
            flags.add(pFlagName);
        } else {
            flags.add(flag);
        }
        return new FlagTerm(flags, pValue);
    }

    private static SearchTermBuilder createUidTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                List<IdRange> uidSetList = IdRange.parseRangeSequence(this.getParameter(0));
                return new UidSearchTerm(uidSetList);
            }
        };
    }

    private static SearchTermBuilder createSequenceSetTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                List<IdRange> idRanges = IdRange.parseRangeSequence(this.getParameter(0));
                return new MessageNumberSearchTerm(idRanges);
            }
        };
    }

    private static Flags.Flag toFlag(String pFlag) {
        if (pFlag == null || pFlag.trim().length() < 1) {
            throw new IllegalArgumentException("Can not convert empty string to mail flag");
        }
        String flag = pFlag.trim().toUpperCase();
        if ("ANSWERED".equals(flag)) {
            return Flags.Flag.ANSWERED;
        }
        if ("DELETED".equals(flag)) {
            return Flags.Flag.DELETED;
        }
        if ("DRAFT".equals(flag)) {
            return Flags.Flag.DRAFT;
        }
        if ("FLAGGED".equals(flag)) {
            return Flags.Flag.FLAGGED;
        }
        if ("RECENT".equals(flag)) {
            return Flags.Flag.RECENT;
        }
        if ("SEEN".equals(flag)) {
            return Flags.Flag.SEEN;
        }
        return null;
    }

    public String toString() {
        return "SearchTermBuilder{key=" + (Object)((Object)this.key) + ", parameters=" + this.parameters + '}';
    }

    public static class UidSearchTerm
    extends AbstractIdSearchTerm {
        private static final long serialVersionUID = 1135219503729412087L;

        public UidSearchTerm(List<IdRange> idRanges) {
            super(idRanges);
        }

        @Override
        public boolean match(Message msg) {
            if (msg instanceof StoredMessage.UidAwareMimeMessage) {
                long uid = ((StoredMessage.UidAwareMimeMessage)msg).getUid();
                return this.match(uid);
            }
            Logger log = LoggerFactory.getLogger(UidSearchTerm.class);
            log.warn("No uid support for message {}, failing to match.", (Object)msg);
            return false;
        }
    }

    public static class MessageNumberSearchTerm
    extends AbstractIdSearchTerm {
        private static final long serialVersionUID = -2792493451441320161L;

        public MessageNumberSearchTerm(List<IdRange> idRanges) {
            super(idRanges);
        }

        @Override
        public boolean match(Message msg) {
            return this.match(msg.getMessageNumber());
        }
    }

    public static abstract class AbstractIdSearchTerm
    extends SearchTerm {
        private static final long serialVersionUID = -5935470270189992292L;
        private final List<IdRange> idRanges;

        public AbstractIdSearchTerm(List<IdRange> idRanges) {
            this.idRanges = idRanges;
        }

        public abstract boolean match(Message var1);

        public boolean match(long id) {
            for (IdRange idRange : this.idRanges) {
                if (!idRange.includes(id)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AllSearchTerm
    extends SearchTerm {
        private static final long serialVersionUID = 135627179677024837L;

        private AllSearchTerm() {
        }

        public boolean match(Message msg) {
            return true;
        }
    }
}

