/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import java.util.Collection;
import javax.mail.internet.MimeMessage;

public class UserImpl
implements GreenMailUser {
    String email;
    private final int cachedHashCode;
    private final String cachedHashCodeAsString;
    String login;
    String password;
    private ImapHostManager imapHostManager;

    public UserImpl(String email, String login, String password, ImapHostManager imapHostManager) {
        this.email = email;
        this.cachedHashCode = email.hashCode();
        this.cachedHashCodeAsString = String.valueOf(this.cachedHashCode);
        this.login = login;
        this.password = password;
        this.imapHostManager = imapHostManager;
    }

    @Override
    public void create() {
        try {
            this.imapHostManager.createPrivateMailAccount(this);
        }
        catch (FolderException e) {
            throw new IllegalStateException("Can not create user" + this, e);
        }
    }

    @Override
    public void delete() {
        try {
            Collection<MailFolder> mailfolders = this.imapHostManager.listMailboxes(this, "*");
            for (MailFolder mf : mailfolders) {
                this.imapHostManager.deleteMailbox(this, mf.getFullName());
            }
        }
        catch (AuthorizationException | FolderException e) {
            throw new IllegalStateException("Can not delete user mailboxes " + this, e);
        }
    }

    @Override
    public void deliver(MovingMessage msg) {
        try {
            this.imapHostManager.getInbox(this).store(msg);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not deliver " + msg + " for user " + this, e);
        }
    }

    @Override
    public void deliver(MimeMessage msg) {
        try {
            this.imapHostManager.getInbox(this).store(msg);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not deliver " + msg + " for user " + this, e);
        }
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getLogin() {
        if (null == this.login) {
            return this.email;
        }
        return this.login;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void authenticate(String pass) throws UserException {
        if (!this.password.equals(pass)) {
            throw new UserException("Invalid password");
        }
    }

    @Override
    public String getQualifiedMailboxName() {
        return this.cachedHashCodeAsString;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserImpl)) {
            return false;
        }
        UserImpl that = (UserImpl)o;
        return this.email.equals(that.email);
    }

    public String toString() {
        return "UserImpl{email='" + this.email + '\'' + ", login='" + this.login + '\'' + '}';
    }
}

