/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public class DataCommand
extends SmtpCommand {
    @Override
    public void execute(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine) throws IOException {
        MovingMessage msg = state.getMessage();
        if (msg.getReturnPath() == null) {
            conn.send("503 MAIL command required");
            return;
        }
        if (msg.getToAddresses().isEmpty()) {
            conn.send("503 RCPT command(s) required");
            return;
        }
        conn.send("354 Start mail input; end with <CRLF>.<CRLF>");
        String initialContent = "Return-Path: <" + msg.getReturnPath() + ">\r\nReceived: from " + conn.getClientAddress() + " (HELO " + conn.getHeloName() + "); " + new Date() + "\r\n";
        try (InputStream messageIs = conn.dotLimitedInputStream(initialContent.getBytes(StandardCharsets.UTF_8));){
            msg.setMimeMessage(GreenMailUtil.newMimeMessage(messageIs));
        }
        String err = manager.checkData(state);
        if (err != null) {
            conn.send(err);
            return;
        }
        try {
            conn.send("250 OK");
            manager.send(state);
        }
        catch (Exception je) {
            this.log.error("Can not send state '250 OK', aborted.", (Throwable)je);
            conn.send("451 Requested action aborted: local error in processing");
        }
        state.clearMessage();
    }
}

