/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import jakarta.mail.Flags;

class StoreCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "STORE";
    public static final String ARGS = "<Message-set> ['+'|'-']FLAG[.SILENT] <flag-list>";
    private final StoreCommandParser storeParser = new StoreCommandParser();

    StoreCommand() {
        super(NAME, ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        long[] uids;
        IdRange[] idSet = this.storeParser.parseIdRange(request);
        StoreDirective directive = this.storeParser.storeDirective(request);
        Flags flags = this.storeParser.flagList(request);
        this.storeParser.endLine(request);
        ImapSessionFolder mailbox = session.getSelected();
        ImapSessionFolder silentListener = null;
        if (directive.isSilent()) {
            silentListener = mailbox;
        }
        for (long uid : uids = mailbox.getMessageUids()) {
            int msn = mailbox.getMsn(uid);
            if ((!useUids || !this.includes(idSet, uid)) && (useUids || !this.includes(idSet, msn))) continue;
            if (directive.getSign() < 0) {
                mailbox.setFlags(flags, false, uid, silentListener, useUids);
                continue;
            }
            if (directive.getSign() > 0) {
                mailbox.setFlags(flags, true, uid, silentListener, useUids);
                continue;
            }
            mailbox.replaceFlags(flags, uid, silentListener, useUids);
        }
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }

    private static class StoreDirective {
        private int sign;
        private boolean silent;

        public StoreDirective(int sign, boolean silent) {
            this.sign = sign;
            this.silent = silent;
        }

        public int getSign() {
            return this.sign;
        }

        public boolean isSilent() {
            return this.silent;
        }
    }

    private static class StoreCommandParser
    extends CommandParser {
        private StoreCommandParser() {
        }

        StoreDirective storeDirective(ImapRequestLineReader request) throws ProtocolException {
            int sign = 0;
            boolean silent = false;
            char next = request.nextWordChar();
            if (next == '+') {
                sign = 1;
                request.consume();
            } else if (next == '-') {
                sign = -1;
                request.consume();
            } else {
                sign = 0;
            }
            String directive = this.consumeWord(request, new CommandParser.NoopCharValidator());
            if ("FLAGS".equalsIgnoreCase(directive)) {
                silent = false;
            } else if ("FLAGS.SILENT".equalsIgnoreCase(directive)) {
                silent = true;
            } else {
                throw new ProtocolException("Invalid Store Directive: '" + directive + '\'');
            }
            return new StoreDirective(sign, silent);
        }
    }
}

