/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.server;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.server.ProtocolHandler;
import com.icegreen.greenmail.util.DummySSLServerSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.Service;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
extends Thread
implements Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final InetAddress bindTo;
    protected ServerSocket serverSocket = null;
    protected static final int CLIENT_SOCKET_SO_TIMEOUT = 30000;
    private int clientSocketTimeout = 30000;
    protected final Managers managers;
    protected ServerSetup setup;
    private final List<ProtocolHandler> handlers = Collections.synchronizedList(new ArrayList());
    private volatile boolean keepRunning = false;
    private volatile boolean running = false;
    private final CountDownLatch startupMonitor = new CountDownLatch(1);

    protected AbstractServer(ServerSetup setup, Managers managers) {
        this.setup = setup;
        String bindAddress = setup.getBindAddress();
        if (null == bindAddress) {
            bindAddress = setup.getDefaultBindAddress();
        }
        try {
            this.bindTo = InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to setup bind address for " + this.getName(), e);
        }
        this.managers = managers;
        this.setName(setup.getProtocol() + ':' + setup.getBindAddress() + ':' + setup.getPort());
    }

    protected abstract ProtocolHandler createProtocolHandler(Socket var1);

    protected ServerSocket openServerSocket() throws IOException {
        ServerSocket socket = this.setup.isSecure() ? DummySSLServerSocketFactory.getDefault().createServerSocket() : new ServerSocket();
        socket.setReuseAddress(true);
        try {
            socket.bind(new InetSocketAddress(this.bindTo, this.setup.getPort()));
        }
        catch (IOException ex) {
            try {
                socket.close();
            }
            catch (IOException nested) {
                this.log.trace("Ignoring attempt to close connection", (Throwable)nested);
            }
            throw ex;
        }
        this.setup = this.setup.withPort(socket.getLocalPort());
        this.setName(this.setup.getProtocol() + ':' + this.setup.getBindAddress() + ':' + this.setup.getPort());
        return socket;
    }

    @Override
    public void run() {
        try {
            this.initServerSocket();
            this.log.debug("Started {}", (Object)this.getName());
            while (this.keepOn()) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    if (!this.keepOn()) {
                        clientSocket.close();
                        continue;
                    }
                    this.handleClientSocket(clientSocket);
                }
                catch (IOException ex) {
                    this.log.trace("Error while processing client socket for {}", (Object)this.getName(), (Object)ex);
                }
            }
        }
        finally {
            this.closeServerSocket();
        }
    }

    protected synchronized void initServerSocket() {
        try {
            this.serverSocket = this.openServerSocket();
            this.setRunning(true);
        }
        catch (IOException e) {
            String msg = "Can not open server socket for " + this.getName();
            this.log.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        finally {
            this.startupMonitor.countDown();
        }
    }

    protected void closeServerSocket() {
        if (null != this.serverSocket) {
            try {
                if (!this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Closed server socket " + this.serverSocket + "/ref=" + Integer.toHexString(System.identityHashCode(this.serverSocket)) + " for " + this.getName());
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to successfully quit server " + this.getName(), e);
            }
        }
    }

    public void setClientSocketTimeout(int clientSocketTimeout) {
        this.clientSocketTimeout = clientSocketTimeout;
    }

    protected void handleClientSocket(Socket clientSocket) throws SocketException {
        clientSocket.setSoTimeout(this.clientSocketTimeout);
        ProtocolHandler handler = this.createProtocolHandler(clientSocket);
        this.addHandler(handler);
        String threadName = this.getName() + "<-" + clientSocket.getInetAddress() + ":" + clientSocket.getPort();
        this.log.debug("Handling new client connection {}", (Object)threadName);
        Thread thread = new Thread(() -> {
            try {
                handler.run();
            }
            finally {
                this.removeHandler(handler);
            }
        });
        thread.setName(threadName);
        thread.start();
    }

    private void addHandler(ProtocolHandler handler) {
        this.handlers.add(handler);
    }

    private void removeHandler(ProtocolHandler handler) {
        this.handlers.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void quit() {
        this.log.debug("Stopping {}", (Object)this.getName());
        this.closeServerSocket();
        List<ProtocolHandler> list = this.handlers;
        synchronized (list) {
            for (ProtocolHandler handler : this.handlers) {
                handler.close();
            }
            this.handlers.clear();
        }
        this.log.debug("Stopped {}", (Object)this.getName());
    }

    public String getBindTo() {
        return this.bindTo.getHostAddress();
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public String getProtocol() {
        return this.setup.getProtocol();
    }

    public ServerSetup getServerSetup() {
        return this.setup;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean waitTillRunning(long timeoutInMs) throws InterruptedException {
        this.startupMonitor.await(timeoutInMs, TimeUnit.MILLISECONDS);
        return this.isRunning();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean r) {
        this.running = r;
    }

    protected final boolean keepOn() {
        return this.keepRunning;
    }

    @Override
    public synchronized void startService() {
        if (!this.keepRunning) {
            this.keepRunning = true;
            this.start();
        }
    }

    @Override
    public final synchronized void stopService(long millis) {
        this.running = false;
        try {
            if (this.keepRunning) {
                this.keepRunning = false;
                this.interrupt();
                this.quit();
                if (0L == millis) {
                    this.join();
                } else {
                    this.join(millis);
                }
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Got interrupted while stopping {}", (Object)this, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public final void stopService() {
        this.stopService(0L);
    }

    public Session createSession(Properties properties) {
        return this.createSession(properties, this.setup.isVerbose());
    }

    public Session createSession(Properties properties, boolean debug) {
        Properties props = this.setup.configureJavaMailSessionProperties(properties, debug);
        if (this.log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder("Server Mail session properties are :");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                if (!entry.getKey().toString().contains("imap")) continue;
                buf.append("\n\t").append(entry.getKey()).append("\t : ").append(entry.getValue());
            }
            this.log.debug(buf.toString());
        }
        return Session.getInstance((Properties)props, null);
    }

    public Session createSession() {
        return this.createSession(null);
    }

    public Store createStore() throws NoSuchProviderException {
        return this.createSession().getStore(this.getProtocol());
    }
}

