/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.configuration.ConfiguredGreenMail;
import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.pop3.Pop3Server;
import com.icegreen.greenmail.server.AbstractServer;
import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.smtp.SmtpServer;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.InMemoryStore;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import com.icegreen.greenmail.util.Service;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenMail
extends ConfiguredGreenMail {
    protected final Logger log = LoggerFactory.getLogger(GreenMail.class);
    protected Managers managers;
    protected Map<String, AbstractServer> services;
    protected ServerSetup[] config;

    public GreenMail() {
        this(ServerSetupTest.ALL);
    }

    public GreenMail(ServerSetup config) {
        this(new ServerSetup[]{config});
    }

    public GreenMail(ServerSetup[] config) {
        this.config = config;
        if (this.log.isDebugEnabled()) {
            this.log.debug("GreenMail version: {}", (Object)BuildInfo.INSTANCE.getProjectVersion());
            this.log.debug("{} {} {}", new Object[]{System.getProperty("java.vm.name", "java.vm.name"), System.getProperty("java.vm.vendor", "java.vm.vendor"), System.getProperty("java.runtime.version", "java.runtime.version")});
            this.log.debug("file.encoding : {}", (Object)System.getProperty("file.encoding", "file.encoding"));
        }
        this.init();
    }

    private void init() {
        if (this.managers == null) {
            this.managers = new Managers();
        }
        if (this.services == null) {
            this.services = this.createServices(this.config, this.managers);
        }
    }

    @Override
    public synchronized void start() {
        this.init();
        Collection<AbstractServer> servers = this.services.values();
        for (AbstractServer service : servers) {
            service.startService();
        }
        for (AbstractServer service : servers) {
            try {
                service.waitTillRunning(service.getServerSetup().getServerStartupTimeout());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Could not start mail service " + service, ex);
            }
        }
        this.log.debug("Started services, performing check if all up");
        for (AbstractServer service : servers) {
            if (service.isRunning()) continue;
            throw new IllegalStateException("Could not start mail server " + service + ", try to set server startup timeout > " + service.getServerSetup().getServerStartupTimeout() + " via " + ServerSetup.class.getSimpleName() + ".setServerStartupTimeout(timeoutInMs) or -Dgreenmail.startup.timeout");
        }
        this.doConfigure();
    }

    @Override
    public synchronized void stop() {
        this.log.debug("Stopping GreenMail ...");
        if (this.services != null) {
            for (Service service : this.services.values()) {
                this.log.debug("Stopping service {}", (Object)service);
                service.stopService();
            }
        }
        this.managers = new Managers();
        this.services = null;
    }

    @Override
    public void reset() {
        this.stop();
        this.start();
    }

    protected Map<String, AbstractServer> createServices(ServerSetup[] config, Managers mgr) {
        HashMap<String, AbstractServer> srvc = new HashMap<String, AbstractServer>();
        for (ServerSetup setup : config) {
            if (srvc.containsKey(setup.getProtocol())) {
                throw new IllegalArgumentException("Server '" + setup.getProtocol() + "' was found at least twice in setup config");
            }
            String protocol = setup.getProtocol();
            if (protocol.startsWith("smtp")) {
                srvc.put(protocol, new SmtpServer(setup, mgr));
                continue;
            }
            if (protocol.startsWith("pop3")) {
                srvc.put(protocol, new Pop3Server(setup, mgr));
                continue;
            }
            if (!protocol.startsWith("imap")) continue;
            srvc.put(protocol, new ImapServer(setup, mgr));
        }
        return srvc;
    }

    @Override
    public SmtpServer getSmtp() {
        return (SmtpServer)this.services.get("smtp");
    }

    @Override
    public ImapServer getImap() {
        return (ImapServer)this.services.get("imap");
    }

    @Override
    public Pop3Server getPop3() {
        return (Pop3Server)this.services.get("pop3");
    }

    @Override
    public SmtpServer getSmtps() {
        return (SmtpServer)this.services.get("smtps");
    }

    @Override
    public ImapServer getImaps() {
        return (ImapServer)this.services.get("imaps");
    }

    @Override
    public Pop3Server getPop3s() {
        return (Pop3Server)this.services.get("pop3s");
    }

    @Override
    public synchronized Managers getManagers() {
        return this.managers;
    }

    @Override
    public UserManager getUserManager() {
        return this.getManagers().getUserManager();
    }

    @Override
    public boolean waitForIncomingEmail(long timeout, int emailCount) {
        CountDownLatch waitObject = this.getManagers().getSmtpManager().createAndAddNewWaitObject(emailCount);
        long endTime = System.currentTimeMillis() + timeout;
        while (waitObject.getCount() > 0L) {
            long waitTime = endTime - System.currentTimeMillis();
            if (waitTime < 0L) {
                return waitObject.getCount() == 0L;
            }
            try {
                waitObject.await(waitTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        return waitObject.getCount() == 0L;
    }

    @Override
    public boolean waitForIncomingEmail(int emailCount) {
        return this.waitForIncomingEmail(5000L, emailCount);
    }

    @Override
    public MimeMessage[] getReceivedMessages() {
        List<StoredMessage> msgs = this.getManagers().getImapHostManager().getAllMessages();
        MimeMessage[] ret = new MimeMessage[msgs.size()];
        for (int i = 0; i < msgs.size(); ++i) {
            StoredMessage storedMessage = msgs.get(i);
            ret[i] = storedMessage.getMimeMessage();
        }
        return ret;
    }

    @Override
    public MimeMessage[] getReceivedMessagesForDomain(String domain) {
        List<StoredMessage> msgs = this.getManagers().getImapHostManager().getAllMessages();
        ArrayList<MimeMessage> ret = new ArrayList<MimeMessage>();
        try {
            for (StoredMessage msg : msgs) {
                String tos = GreenMailUtil.getAddressList(msg.getMimeMessage().getAllRecipients());
                if (null == tos || !tos.toLowerCase().contains(domain.toLowerCase())) continue;
                ret.add(msg.getMimeMessage());
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return ret.toArray(new MimeMessage[0]);
    }

    @Override
    public GreenMailUser setUser(String login, String password) {
        return this.setUser(login, login, password);
    }

    @Override
    public GreenMailUser setUser(String email, String login, String password) {
        UserManager userManager = this.getUserManager();
        GreenMailUser user = userManager.getUser(login);
        if (null == user) {
            try {
                user = userManager.createUser(email, login, password);
            }
            catch (UserException e) {
                throw new RuntimeException(e);
            }
        } else {
            user.setPassword(password);
        }
        return user;
    }

    @Override
    public void setQuotaSupported(boolean isEnabled) {
        this.getManagers().getImapHostManager().getStore().setQuotaSupported(isEnabled);
    }

    @Override
    public void setUsers(Properties users) {
        for (Object o : users.keySet()) {
            String email = (String)o;
            String password = users.getProperty(email);
            this.setUser(email, email, password);
        }
    }

    @Override
    public GreenMail withConfiguration(GreenMailConfiguration config) {
        super.withConfiguration(config);
        return this;
    }

    @Override
    public void purgeEmailFromAllMailboxes() throws FolderException {
        ImapHostManager imapHostManager = this.getManagers().getImapHostManager();
        InMemoryStore store = (InMemoryStore)imapHostManager.getStore();
        Collection<MailFolder> mailboxes = store.listMailboxes("*");
        for (MailFolder folder : mailboxes) {
            folder.deleteAllMessages();
        }
    }

    @Override
    public boolean isRunning() {
        for (AbstractServer service : this.services.values()) {
            if (service.isRunning()) continue;
            this.log.debug("Service {} is not running", (Object)service);
            return false;
        }
        return true;
    }
}

