/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SearchKey;
import com.icegreen.greenmail.imap.commands.SearchTermBuilder;
import jakarta.mail.search.AndTerm;
import jakarta.mail.search.NotTerm;
import jakarta.mail.search.OrTerm;
import jakarta.mail.search.SearchTerm;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Deque;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchCommandParser
extends CommandParser {
    private final Logger log = LoggerFactory.getLogger(SearchCommandParser.class);
    private static final String CHARSET_TOKEN = "CHARSET";

    SearchCommandParser() {
    }

    public SearchTerm searchTerm(ImapRequestLineReader request) throws ProtocolException {
        char next;
        Charset charset = StandardCharsets.US_ASCII;
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.push((Object)SearchOperator.GROUP);
        while ((next = request.nextChar()) != '\n' && next != '\r') {
            next = request.consumeAll(' ');
            if (this.isAtomSpecial(next)) {
                if (next == '(') {
                    request.consume();
                    request.consumeAll(' ');
                    stack.push((Object)SearchOperator.GROUP);
                    continue;
                }
                if (next == ')') {
                    Object item;
                    request.consume();
                    request.consumeAll(' ');
                    LinkedList<SearchTerm> groupItems = new LinkedList<SearchTerm>();
                    while ((item = stack.pop()) != SearchOperator.GROUP) {
                        groupItems.addFirst((SearchTerm)item);
                    }
                    if (groupItems.size() == 1) {
                        stack.push(groupItems.get(0));
                        continue;
                    }
                    stack.push(new AndTerm(groupItems.toArray(new SearchTerm[0])));
                    continue;
                }
                throw new IllegalStateException("Unsupported atom special char <" + next + ">");
            }
            String token = this.atomOnly(request);
            if (IdRange.SEQUENCE.matcher(token).matches()) {
                stack.push(SearchTermBuilder.create(SearchKey.SEQUENCE_SET).addParameter(token).build());
                continue;
            }
            if (CHARSET_TOKEN.equals(token)) {
                request.consumeAll(' ');
                String charsetName = this.astring(request);
                try {
                    charset = Charset.forName(charsetName);
                    continue;
                }
                catch (UnsupportedCharsetException ex) {
                    this.log.error("Unsupported charset '{}", (Object)charsetName);
                    throw ex;
                }
            }
            SearchKey key = SearchKey.valueOf(token);
            if (key == SearchKey.NOT) {
                stack.push((Object)SearchOperator.NOT);
                continue;
            }
            if (key == SearchKey.OR) {
                stack.push((Object)SearchOperator.OR);
                continue;
            }
            SearchTermBuilder b = SearchTermBuilder.create(key);
            if (b.expectsParameter()) {
                for (int pi = 0; pi < key.getNumberOfParameters(); ++pi) {
                    request.consumeAll(' ');
                    this.handleSearchArg(request, key, b, charset);
                }
            }
            stack.push(b.build());
        }
        return this.handleOperators(stack);
    }

    private void handleSearchArg(ImapRequestLineReader request, SearchKey key, SearchTermBuilder searchTermBuilder, Charset charset) throws ProtocolException {
        String paramValue;
        switch (key.getArgDataFormat()) {
            case STRING: {
                paramValue = this.string(request, charset);
                break;
            }
            case ATOM: {
                paramValue = this.atomOnly(request);
                break;
            }
            default: {
                throw new IllegalStateException("Argument type " + (Object)((Object)key.getArgDataFormat()) + " not implemented for key " + (Object)((Object)key));
            }
        }
        searchTermBuilder.addParameter(paramValue);
    }

    private SearchTerm handleOperators(Deque<Object> stack) {
        LinkedList<Object> params = new LinkedList<Object>();
        while (!stack.isEmpty()) {
            SearchTerm term2;
            SearchTerm term1;
            Object o = stack.pop();
            if (SearchOperator.OR == o) {
                term1 = (SearchTerm)params.pop();
                term2 = (SearchTerm)params.pop();
                params.push(new OrTerm(term1, term2));
                continue;
            }
            if (SearchOperator.NOT == o) {
                params.push(new NotTerm((SearchTerm)params.pop()));
                continue;
            }
            if (SearchOperator.AND == o) {
                term1 = (SearchTerm)params.pop();
                term2 = (SearchTerm)params.pop();
                params.push(new AndTerm(term1, term2));
                continue;
            }
            if (SearchOperator.GROUP == o) {
                if (params.size() <= 1) continue;
                SearchTerm[] items = params.toArray(new SearchTerm[0]);
                params.clear();
                params.push(new AndTerm(items));
                continue;
            }
            if (o instanceof SearchTerm) {
                params.push((SearchTerm)o);
                continue;
            }
            throw new IllegalStateException("Unsupported stack item " + o);
        }
        if (params.size() != 1) {
            throw new IllegalStateException("Expected exactly one root search term but got " + params);
        }
        return (SearchTerm)params.pop();
    }

    protected static enum DataFormats {
        ATOM,
        STRING;

    }

    protected static enum SearchOperator {
        AND,
        OR,
        NOT,
        GROUP;

    }
}

