/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.auth.LoginAuthenticationState;
import com.icegreen.greenmail.smtp.auth.PlainAuthenticationState;
import com.icegreen.greenmail.smtp.auth.XOAuth2AuthenticationState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.SaslMessage;
import com.icegreen.greenmail.util.SaslXoauth2Message;
import java.io.IOException;
import java.util.Arrays;

public class AuthCommand
extends SmtpCommand {
    public static final String AUTH_SUCCEDED = "235 2.7.0  Authentication Succeeded";
    public static final String AUTH_CREDENTIALS_INVALID = "535 5.7.8  Authentication credentials invalid";
    public static final String AUTH_ALREADY_AUTHENTICATED = "503 already authenticated";
    public static final String SMTP_SYNTAX_ERROR = "500 syntax error";
    public static final String SMTP_SERVER_CONTINUATION = "334 ";
    public static final String SUPPORTED_AUTH_MECHANISM = AuthCommand.getValuesWsSeparated();

    @Override
    public void execute(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine) throws IOException {
        if (conn.isAuthenticated()) {
            conn.send(AUTH_ALREADY_AUTHENTICATED);
            return;
        }
        String[] commandParts = commandLine.split(" ");
        if (commandParts.length < 2) {
            conn.send("500 syntax error : expected mechanism but received <" + commandLine + ">");
            return;
        }
        String authMechanismValue = commandParts[1];
        if (AuthMechanism.LOGIN.name().equalsIgnoreCase(authMechanismValue)) {
            this.authLogin(conn, state, manager, commandLine, commandParts, authMechanismValue);
        } else if (AuthMechanism.PLAIN.name().equalsIgnoreCase(authMechanismValue)) {
            this.authPlain(conn, state, manager, commandParts);
        } else if (AuthMechanism.XOAUTH2.name().equalsIgnoreCase(authMechanismValue)) {
            this.authXOAuth2(conn, state, manager, commandParts);
        } else {
            conn.send("500 syntax error : Unsupported auth mechanism " + authMechanismValue + ". Only auth mechanism <" + Arrays.toString((Object[])AuthMechanism.values()) + "> supported.");
        }
    }

    private void authPlain(SmtpConnection conn, SmtpState state, SmtpManager manager, String[] commandParts) throws IOException {
        String initialResponse;
        if (commandParts.length == 2) {
            conn.send(SMTP_SERVER_CONTINUATION);
            initialResponse = conn.readLine();
        } else {
            initialResponse = commandParts[2];
        }
        SaslMessage saslMessage = this.parseInitialResponse(initialResponse);
        PlainAuthenticationState authenticationContext = new PlainAuthenticationState(saslMessage);
        state.getMessage().setAuthenticationState(authenticationContext);
        if (this.authenticate(manager.getUserManager(), saslMessage)) {
            conn.setAuthenticated(true);
            conn.send(AUTH_SUCCEDED);
        } else {
            conn.send(AUTH_CREDENTIALS_INVALID);
        }
    }

    private void authLogin(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine, String[] commandParts, String authMechanismValue) throws IOException {
        if (commandParts.length != 2) {
            conn.send("500 syntax error : Unsupported auth mechanism " + authMechanismValue + " with unexpected values. Line is: <" + commandLine + ">");
        } else {
            conn.send("334 VXNlcm5hbWU6");
            String username = conn.readLine();
            conn.send("334 UGFzc3dvcmQ6");
            String pwd = conn.readLine();
            String plainUsername = EncodingUtil.decodeBase64(username);
            String plainPwd = EncodingUtil.decodeBase64(pwd);
            LoginAuthenticationState authenticationContext = new LoginAuthenticationState(plainUsername, plainPwd);
            state.getMessage().setAuthenticationState(authenticationContext);
            if (manager.getUserManager().test(plainUsername, plainPwd)) {
                conn.setAuthenticated(true);
                conn.send(AUTH_SUCCEDED);
            } else {
                conn.send(AUTH_CREDENTIALS_INVALID);
            }
        }
    }

    private void authXOAuth2(SmtpConnection conn, SmtpState state, SmtpManager manager, String[] commandParts) {
        if (commandParts.length != 3) {
            conn.send("500 syntax error : Unsupported auth mechanism with unexpected values. Line is: <" + Arrays.toString(commandParts) + ">");
        } else {
            XOAuth2AuthenticationState authenticationContext = new XOAuth2AuthenticationState(SaslXoauth2Message.parseBase64Encoded(commandParts[2]));
            state.getMessage().setAuthenticationState(authenticationContext);
            if (manager.getUserManager().test(authenticationContext.getUsername(), authenticationContext.getAccessToken())) {
                conn.setAuthenticated(true);
                conn.send(AUTH_SUCCEDED);
            } else {
                conn.send(AUTH_CREDENTIALS_INVALID);
            }
        }
    }

    private boolean authenticate(UserManager userManager, SaslMessage saslMessage) {
        return userManager.test(saslMessage.getAuthcid(), saslMessage.getPasswd());
    }

    private SaslMessage parseInitialResponse(String initialResponse) {
        String value = EncodingUtil.decodeBase64(initialResponse);
        return SaslMessage.parse(value);
    }

    private static String getValuesWsSeparated() {
        StringBuilder buf = new StringBuilder();
        for (AuthMechanism mechanism : AuthMechanism.values()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append((Object)mechanism);
        }
        return buf.toString();
    }

    public static enum AuthMechanism {
        PLAIN,
        LOGIN,
        XOAUTH2;

    }
}

