/*
 * Decompiled with CFR 0.152.
 */
package com.icfolson.sling.translate.api.model;

import com.icfolson.sling.translate.api.model.TranslationModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DictionaryModel {
    private final Class<?> dictionaryClass;
    private final Map<Method, TranslationModel> entries = new HashMap<Method, TranslationModel>();
    private String i18nPath;

    public DictionaryModel(Class<?> dictionaryClass) {
        this.dictionaryClass = dictionaryClass;
    }

    public Class<?> getDictionaryClass() {
        return this.dictionaryClass;
    }

    public TranslationModel addEntry(TranslationModel model) {
        this.entries.put(model.getEntryMethod(), model);
        return model;
    }

    public TranslationModel getEntry(Method method) {
        return this.entries.get(method);
    }

    public TranslationModel removeEntry(Method method) {
        return this.entries.remove(method);
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }

    public List<TranslationModel> getEntries() {
        return new ArrayList<TranslationModel>(this.entries.values());
    }

    public String getI18nPath() {
        return this.i18nPath;
    }

    public void setI18nPath(String i18nPath) {
        this.i18nPath = i18nPath;
    }
}

