/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.repository;

import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.client.repository.NamedByteArrayResource;
import com.icthh.xm.commons.config.client.utils.RequestUtils;
import com.icthh.xm.commons.config.domain.Configuration;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class TenantConfigRepository {
    private static final Logger log = LoggerFactory.getLogger(TenantConfigRepository.class);
    static final String OLD_CONFIG_HASH = "oldConfigHash";
    private static final String TENANT_NAME = "tenantName";
    private static final String PATH_API = "/api";
    private static final String PATH_CONFIG = "/config";
    public static final String PATH_CONFIG_TENANT = "/config/tenants/{tenantName}/";
    public static final String PATH_API_CONFIG_TENANT = "/api/config/tenants/{tenantName}/";
    private static final String MULTIPART_FILE_NAME = "files";
    private static final String TENANT_PATH_PATTERN = "/**/config/tenants/{tenantName:[A-Z0-9]+|\\{tenantName\\}}/**";
    private static final String TENANT_NAME_PATTERN = "[A-Z0-9]+";
    private static final String TENANT_NAME_REPLACE = "\\{tenantName}";
    private final RestTemplate restTemplate;
    private final String applicationName;
    private final String xmConfigUrl;
    private final AntPathMatcher matcher = new AntPathMatcher();

    public TenantConfigRepository(RestTemplate restTemplate, String applicationName, XmConfigProperties applicationProperties) {
        this.restTemplate = restTemplate;
        this.xmConfigUrl = applicationProperties.getXmConfigUrl();
        this.applicationName = applicationName;
    }

    public void createConfig(String tenantName, String path, String content) {
        HttpEntity entity = new HttpEntity((Object)content, (MultiValueMap)RequestUtils.createAuthHeaders());
        this.exchangePost(tenantName, this.getServiceConfigUrl() + path, entity);
    }

    public void createConfigs(String tenantName, List<Configuration> configurations) {
        String upperTenantName = tenantName.toUpperCase();
        this.assertTenantNameValid(upperTenantName);
        List<NamedByteArrayResource> resources = configurations.stream().map(this::toFullPath).map(configuration -> this.toNamedResource(upperTenantName, (Configuration)configuration)).collect(Collectors.toList());
        this.exchangePostMultipart(resources);
    }

    public void updateConfig(String tenantName, String path, String content) {
        HttpEntity entity = new HttpEntity((Object)content, (MultiValueMap)RequestUtils.createAuthHeaders());
        this.exchangePut(tenantName, this.getServiceConfigUrl() + path, (HttpEntity<String>)entity);
    }

    public void updateConfig(String tenantName, String path, String content, String oldConfigHash) {
        HttpEntity entity = new HttpEntity((Object)content, (MultiValueMap)RequestUtils.createAuthHeaders());
        String pathWithHash = this.toUrlWithOldHash(tenantName, this.getServiceConfigUrl() + path, oldConfigHash);
        this.exchangePut(null, pathWithHash, (HttpEntity<String>)entity);
    }

    public void deleteConfig(String tenantName, String path) {
        HttpEntity entity = new HttpEntity((MultiValueMap)RequestUtils.createAuthHeaders());
        this.exchangeDelete(tenantName, this.getServiceConfigUrl() + path, entity);
    }

    public void createConfigFullPath(String tenantName, String fullPath, String content) {
        HttpEntity entity = new HttpEntity((Object)content, (MultiValueMap)RequestUtils.createAuthHeaders());
        this.exchangePost(tenantName, this.xmConfigUrl + fullPath, entity);
    }

    public void createConfigsFullPath(String tenantName, List<Configuration> configurations) {
        String upperTenantName = tenantName.toUpperCase();
        this.assertTenantNameValid(upperTenantName);
        List<NamedByteArrayResource> resources = configurations.stream().map(configuration -> this.toNamedResource(upperTenantName, (Configuration)configuration)).collect(Collectors.toList());
        this.exchangePostMultipart(resources);
    }

    public void updateConfigFullPath(String tenantName, String fullPath, String content) {
        HttpEntity entity = new HttpEntity((Object)content, (MultiValueMap)RequestUtils.createAuthHeaders());
        this.exchangePut(tenantName, this.xmConfigUrl + fullPath, (HttpEntity<String>)entity);
    }

    public void updateConfigFullPath(String tenantName, String fullPath, String content, String oldConfigHash) {
        HttpEntity entity = new HttpEntity((Object)content, (MultiValueMap)RequestUtils.createAuthHeaders());
        String path = this.toUrlWithOldHash(tenantName, this.xmConfigUrl + fullPath, oldConfigHash);
        this.exchangePut(null, path, (HttpEntity<String>)entity);
    }

    public void deleteConfigFullPath(String tenantName, String fullPath) {
        HttpEntity entity = new HttpEntity((MultiValueMap)RequestUtils.createAuthHeaders());
        this.exchangeDelete(tenantName, this.xmConfigUrl + fullPath, entity);
    }

    public void deleteConfigFullPaths(String tenantName, List<String> fullPath) {
        List tenantResolved = fullPath.stream().map(s -> this.resolveTenantName((String)s, tenantName)).collect(Collectors.toList());
        HttpEntity entity = new HttpEntity(tenantResolved, (MultiValueMap)RequestUtils.createJsonAuthHeaders());
        this.exchangeDelete(tenantName, this.xmConfigUrl + PATH_API_CONFIG_TENANT, entity);
    }

    public String getConfigFullPath(String tenantName, String path) {
        HttpEntity entity = new HttpEntity((MultiValueMap)RequestUtils.createAuthHeaders());
        return (String)this.exchangeGet(tenantName, this.xmConfigUrl + path, (HttpEntity<String>)entity).getBody();
    }

    private ResponseEntity<String> exchangeGet(String tenantName, String path, HttpEntity<String> entity) {
        return this.exchange(path, HttpMethod.GET, entity, String.class, tenantName);
    }

    private void exchangePut(String tenantName, String path, HttpEntity<String> entity) {
        this.exchange(path, HttpMethod.PUT, entity, tenantName);
    }

    private void exchangeDelete(String tenantName, String path, HttpEntity<?> entity) {
        this.exchange(path, HttpMethod.DELETE, entity, tenantName);
    }

    private void exchangePost(String tenantName, String path, HttpEntity<?> entity) {
        this.exchange(path, HttpMethod.POST, entity, tenantName);
    }

    private void exchange(String path, HttpMethod method, HttpEntity<?> entity, String tenantName) {
        this.exchange(path, method, entity, Void.class, tenantName);
    }

    private <T> ResponseEntity<T> exchange(String path, HttpMethod method, HttpEntity<?> entity, Class<T> respClass, String tenantName) {
        this.assertPathInsideTenant(path);
        if (tenantName != null) {
            String upperTenantName = tenantName.toUpperCase();
            this.assertTenantNameValid(upperTenantName);
            return this.restTemplate.exchange(path, method, entity, respClass, new Object[]{upperTenantName});
        }
        return this.restTemplate.exchange(path, method, entity, respClass, new Object[0]);
    }

    private void exchangePostMultipart(List<NamedByteArrayResource> resources) {
        resources.forEach(namedByteArrayResource -> this.assertPathInsideTenant(namedByteArrayResource.getFilename()));
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.addAll((Object)MULTIPART_FILE_NAME, resources);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)RequestUtils.createMultipartAuthHeaders());
        this.restTemplate.exchange(this.xmConfigUrl + PATH_API + PATH_CONFIG, HttpMethod.POST, entity, Void.class, new Object[0]);
    }

    private String toUrlWithOldHash(String tenantName, String path, String oldConfigHash) {
        HashMap<String, String> uriParams = new HashMap<String, String>();
        uriParams.put(TENANT_NAME, tenantName.toUpperCase());
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)path).queryParam(OLD_CONFIG_HASH, new Object[]{oldConfigHash});
        return builder.buildAndExpand(uriParams).toUri().toString();
    }

    void assertTenantNameValid(String tenantName) {
        Objects.requireNonNull(tenantName, "tenantName can not be null");
        if (!tenantName.matches(TENANT_NAME_PATTERN)) {
            throw new IllegalArgumentException("Tenant name has wrong format: " + tenantName);
        }
    }

    void assertPathInsideTenant(String path) {
        Objects.requireNonNull(path, "path can not be null");
        String contextPath = path;
        if (path.startsWith("http")) {
            contextPath = new URL(path).getPath();
        }
        if (!this.matcher.match(TENANT_PATH_PATTERN, contextPath)) {
            throw new IllegalArgumentException("Execution is not allowed for path: " + contextPath);
        }
    }

    private String getServiceConfigUrl() {
        return this.xmConfigUrl + PATH_API_CONFIG_TENANT + this.applicationName;
    }

    private Configuration toFullPath(Configuration configuration) {
        return new Configuration(Paths.get(PATH_CONFIG_TENANT, this.applicationName, configuration.getPath()).toString(), configuration.getContent());
    }

    private String resolveTenantName(String path, String tenantName) {
        return path.replaceAll(TENANT_NAME_REPLACE, tenantName.toUpperCase());
    }

    private NamedByteArrayResource toNamedResource(String tenantName, Configuration configuration) {
        return new NamedByteArrayResource(configuration.getContent().getBytes(), this.resolveTenantName(configuration.getPath(), tenantName));
    }
}

