/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class TenantConfigService
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TenantConfigService.class);
    private static final String TENANT_NAME = "tenantName";
    public static final String DEFAULT_TENANT_CONFIG_PATTERN = "/config/tenants/{tenantName}/tenant-config.yml";
    private ConcurrentHashMap<String, Map<String, Object>> tenantConfig = new ConcurrentHashMap();
    private final XmConfigProperties xmConfigProperties;
    private final AntPathMatcher matcher = new AntPathMatcher();
    private ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final TenantContextHolder tenantContextHolder;

    public TenantConfigService(XmConfigProperties xmConfigProperties, TenantContextHolder tenantContextHolder) {
        this.xmConfigProperties = xmConfigProperties;
        this.tenantContextHolder = tenantContextHolder;
    }

    @IgnoreLogginAspect
    public Map<String, Object> getConfig() {
        return this.getTenantConfig();
    }

    private Map<String, Object> getTenantConfig() {
        return this.tenantConfig.getOrDefault(this.getTenantKeyValue(), Collections.emptyMap());
    }

    private String getTenantKeyValue() {
        return TenantContextUtils.getRequiredTenantKeyValue((TenantContextHolder)this.tenantContextHolder);
    }

    private String getTenantConfigPattern() {
        String tenantConfigPattern = this.xmConfigProperties.getTenantConfigPattern();
        return StringUtils.isBlank((CharSequence)tenantConfigPattern) ? DEFAULT_TENANT_CONFIG_PATTERN : tenantConfigPattern;
    }

    private void processMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        map.entrySet().forEach(e -> {
            Object value = e.getValue();
            if (value instanceof Map) {
                Map inner = (Map)value;
                e.setValue(Collections.unmodifiableMap(inner));
                this.processMap(inner);
            } else if (value instanceof List) {
                List inner = (List)value;
                e.setValue(Collections.unmodifiableList(inner));
                this.processList(inner);
            }
        });
    }

    private void processList(List<Object> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object inner;
            Object item = list.get(i);
            if (item instanceof Map) {
                inner = (Map)item;
                list.set(i, Collections.unmodifiableMap(inner));
                this.processMap((Map<String, Object>)inner);
                continue;
            }
            if (!(item instanceof List)) continue;
            inner = (List)item;
            list.set(i, Collections.unmodifiableList(inner));
            this.processList((List<Object>)inner);
        }
    }

    @Override
    public void onRefresh(String updatedKey, String config) {
        try {
            String tenant = this.getTenantKey(updatedKey);
            if (StringUtils.isBlank((CharSequence)config)) {
                this.tenantConfig.remove(tenant);
                return;
            }
            Map configMap = (Map)this.mapper.readValue(config, Map.class);
            this.processMap(configMap);
            this.tenantConfig.put(tenant, Collections.unmodifiableMap(configMap));
            log.info("Tenant configuration was updated for tenant [{}] by key [{}]", (Object)tenant, (Object)updatedKey);
        }
        catch (Exception e) {
            log.error("Error read tenant configuration from path " + updatedKey, (Throwable)e);
        }
    }

    public String getTenantKey(String updatedKey) {
        String tenantConfigPattern = this.getTenantConfigPattern();
        return (String)this.matcher.extractUriTemplateVariables(tenantConfigPattern, updatedKey).get(TENANT_NAME);
    }

    @Override
    public boolean isListeningConfiguration(String updatedKey) {
        String tenantConfigPattern = this.getTenantConfigPattern();
        return this.matcher.match(tenantConfigPattern, updatedKey);
    }

    @Override
    public void onInit(String configKey, String configValue) {
        if (this.isListeningConfiguration(configKey)) {
            this.onRefresh(configKey, configValue);
        }
    }
}

