/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.config;

import com.icthh.xm.commons.config.client.api.ConfigService;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.config.domain.Configuration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class InitRefreshableConfigurationBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(InitRefreshableConfigurationBeanPostProcessor.class);
    public static final String LOG_CONFIG_EMPTY = "<CONFIG_EMPTY>";
    private final ConfigService configService;
    private final Map<String, RefreshableConfiguration> refreshableConfigurations = new HashMap<String, RefreshableConfiguration>();
    private Map<String, Configuration> configMap;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof RefreshableConfiguration) {
            this.refreshableConfigurations.put(beanName, (RefreshableConfiguration)bean);
            log.info("refreshable configuration bean added: {} = {}", (Object)beanName, bean.getClass());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (this.refreshableConfigurations.containsKey(beanName)) {
            this.initBean(this.refreshableConfigurations.get(beanName), this.getConfig());
        }
        return bean;
    }

    private Map<String, Configuration> getConfig() {
        if (this.configMap == null) {
            this.configMap = this.configService.getConfigurationMap(null);
        }
        return this.configMap;
    }

    private void initBean(RefreshableConfiguration refreshableConfiguration, Map<String, Configuration> configMap) {
        configMap.forEach((key, value) -> {
            if (refreshableConfiguration.isListeningConfiguration((String)key)) {
                log.info("Process config init event: [key = {}, size = {}, newHash = {}] in bean: [{}]", new Object[]{key, StringUtils.length((CharSequence)value.getContent()), InitRefreshableConfigurationBeanPostProcessor.getValueHash(value.getContent()), InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration)});
                refreshableConfiguration.onInit((String)key, value.getContent());
            }
        });
        log.info("refreshable configuration bean [{}] initialized by configMap with {} entries", (Object)InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration), (Object)configMap.size());
        this.configService.addConfigurationChangedListener(configuration -> this.onEntryChange(refreshableConfiguration, configuration));
    }

    private void onEntryChange(RefreshableConfiguration refreshableConfiguration, Configuration configuration) {
        String configContent = configuration.getContent();
        if (refreshableConfiguration.isListeningConfiguration(configuration.getPath())) {
            refreshableConfiguration.onRefresh(configuration.getPath(), configContent);
            log.info("Process config update event: [path = {}, size = {}, hash = {}] in bean: [{}]", new Object[]{configuration.getPath(), StringUtils.length((CharSequence)configContent), InitRefreshableConfigurationBeanPostProcessor.getValueHash(configContent), InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration)});
        } else {
            log.debug("Ignored config update event: [path = {}, configSize = {} in bean [{}]", new Object[]{configuration.getPath(), StringUtils.length((CharSequence)configContent), InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration)});
        }
    }

    private static String getBeanName(RefreshableConfiguration refreshableConfiguration) {
        return refreshableConfiguration.getClass().getSimpleName();
    }

    private static String getValueHash(String configContent) {
        return StringUtils.isEmpty((CharSequence)configContent) ? LOG_CONFIG_EMPTY : DigestUtils.md5Hex((String)configContent);
    }

    public InitRefreshableConfigurationBeanPostProcessor(ConfigService configService) {
        this.configService = configService;
    }
}

