/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.repository;

import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.client.utils.RequestUtils;
import com.icthh.xm.commons.config.domain.Configuration;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CommonConfigRepository {
    private static final Logger log = LoggerFactory.getLogger(CommonConfigRepository.class);
    private static final String URL = "/api/private";
    private static final String VERSION = "version";
    private final RestTemplate restTemplate;
    private final XmConfigProperties xmConfigProperties;

    public Map<String, Configuration> getConfig(String commit) {
        ParameterizedTypeReference<Map<String, Configuration>> typeRef = new ParameterizedTypeReference<Map<String, Configuration>>(){};
        HttpEntity entity = new HttpEntity((MultiValueMap)RequestUtils.createSimpleHeaders());
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(this.getServiceConfigUrl() + "/config_map")).queryParam(VERSION, new Object[]{commit});
        return (Map)this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, entity, (ParameterizedTypeReference)typeRef, new Object[0]).getBody();
    }

    private String getServiceConfigUrl() {
        return this.xmConfigProperties.getXmConfigUrl() + URL;
    }

    public Map<String, Configuration> getConfig(String version, Collection<String> paths) {
        ParameterizedTypeReference<Map<String, Configuration>> typeRef = new ParameterizedTypeReference<Map<String, Configuration>>(){};
        HttpEntity entity = new HttpEntity((Object)new GetConfigRequest(version, paths), (MultiValueMap)RequestUtils.createApplicationJsonHeaders());
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(this.getServiceConfigUrl() + "/config_map"));
        return (Map)this.restTemplate.exchange(builder.toUriString(), HttpMethod.POST, entity, (ParameterizedTypeReference)typeRef, new Object[0]).getBody();
    }

    public void updateConfigFullPath(Configuration configuration, String oldConfigHash) {
        HttpEntity entity = new HttpEntity((Object)configuration);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(this.getServiceConfigUrl() + "/config")).queryParam("oldConfigHash", new Object[]{oldConfigHash});
        this.restTemplate.exchange(builder.toUriString(), HttpMethod.PUT, entity, Void.class, new Object[0]);
    }

    public CommonConfigRepository(RestTemplate restTemplate, XmConfigProperties xmConfigProperties) {
        this.restTemplate = restTemplate;
        this.xmConfigProperties = xmConfigProperties;
    }

    private static class GetConfigRequest {
        private String version;
        private Collection<String> paths;

        public String getVersion() {
            return this.version;
        }

        public Collection<String> getPaths() {
            return this.paths;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setPaths(Collection<String> paths) {
            this.paths = paths;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetConfigRequest)) {
                return false;
            }
            GetConfigRequest other = (GetConfigRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Collection<String> this$paths = this.getPaths();
            Collection<String> other$paths = other.getPaths();
            return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetConfigRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Collection<String> $paths = this.getPaths();
            result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
            return result;
        }

        public String toString() {
            return "CommonConfigRepository.GetConfigRequest(version=" + this.getVersion() + ", paths=" + this.getPaths() + ")";
        }

        public GetConfigRequest(String version, Collection<String> paths) {
            this.version = version;
            this.paths = paths;
        }

        public GetConfigRequest() {
        }
    }
}

