/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.utils;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;

public final class TokenUtils {
    public static String extractCurrentToken() {
        OAuth2Authentication auth = TokenUtils.getAuthentication();
        if (auth == null) {
            throw new IllegalStateException("Cannot get current authentication object");
        }
        if (auth.getDetails() == null) {
            return null;
        }
        if (auth.getDetails() instanceof OAuth2AuthenticationDetails) {
            return ((OAuth2AuthenticationDetails)OAuth2AuthenticationDetails.class.cast(auth.getDetails())).getTokenValue();
        }
        if (auth.getDetails() instanceof String) {
            return String.valueOf(auth.getDetails());
        }
        return null;
    }

    private static OAuth2Authentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof OAuth2Authentication) {
            return (OAuth2Authentication)SecurityContextHolder.getContext().getAuthentication();
        }
        return null;
    }

    private TokenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

