/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.config;

import com.icthh.xm.commons.config.client.exception.ConflictUpdateConfigException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(value={"xm-config.enabled"})
public class XmRestTemplateConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XmRestTemplateConfiguration.class);
    public static final String XM_CONFIG_REST_TEMPLATE = "xm-config-rest-template";

    @Bean(value={"xm-config-rest-template"})
    public RestTemplate restTemplate(RestTemplateCustomizer customizer) {
        RestTemplate restTemplate = new RestTemplate();
        customizer.customize(restTemplate);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                if (response.getStatusCode() == HttpStatus.CONFLICT) {
                    throw new ConflictUpdateConfigException();
                }
                super.handleError(response);
            }
        });
        return restTemplate;
    }
}

