/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.repository.kafka;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.config.client.api.ConfigService;
import com.icthh.xm.commons.config.domain.ConfigEvent;
import com.icthh.xm.commons.logging.util.MdcUtils;
import java.io.IOException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class ConfigTopicConsumer {
    private static final Logger log = LoggerFactory.getLogger(ConfigTopicConsumer.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule());
    private final ConfigService configService;

    @Retryable(maxAttemptsExpression="${application.retry.max-attempts}", backoff=@Backoff(delayExpression="${application.retry.delay}", multiplierExpression="${application.retry.multiplier}"))
    public void consumeEvent(ConsumerRecord<String, String> message) {
        MdcUtils.putRid();
        try {
            log.info("Consume event from topic [{}]", (Object)message.topic());
            try {
                ConfigEvent event = (ConfigEvent)this.mapper.readValue((String)message.value(), ConfigEvent.class);
                log.info("Process event from topic [{}], event_id ='{}', commit: '{}'", new Object[]{message.topic(), event.getEventId(), event.getCommit()});
                this.configService.updateConfigurations(event.getCommit(), event.getPaths());
            }
            catch (IOException e) {
                log.error("Config topic message has incorrect format: '{}'", message.value(), (Object)e);
            }
        }
        finally {
            MdcUtils.removeRid();
        }
    }

    public ConfigTopicConsumer(ConfigService configService) {
        this.configService = configService;
    }
}

