/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.config.domain.TenantAliasTree;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAliasService
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TenantAliasService.class);
    public static final String TENANT_ALIAS_CONFIG = "/config/tenants/tenant-aliases.yml";
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private volatile TenantAliasTree tenantAliasTree = new TenantAliasTree();

    @Override
    public void onRefresh(String updatedKey, String config) {
        try {
            TenantAliasTree tenantAliasTree = (TenantAliasTree)this.mapper.readValue(config, TenantAliasTree.class);
            tenantAliasTree.init();
            this.tenantAliasTree = tenantAliasTree;
        }
        catch (IOException e) {
            log.error("Error parse tenant alias config", (Throwable)e);
        }
    }

    @Override
    public boolean isListeningConfiguration(String path) {
        return TENANT_ALIAS_CONFIG.equals(path);
    }

    @Override
    public void onInit(String configKey, String configValue) {
        this.onRefresh(configKey, configValue);
    }

    public TenantAliasTree getTenantAliasTree() {
        return this.tenantAliasTree;
    }
}

