/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.api.refreshable;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractRefreshableConfiguration<CONFIG, CONFIG_FILE>
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractRefreshableConfiguration.class);
    private static final String TENANT_NAME = "tenantName";
    protected final Map<String, CONFIG> configurationsByTenant = new ConcurrentHashMap<String, CONFIG>();
    protected final Map<String, Map<String, CONFIG_FILE>> configurationsByTenantByFile = new ConcurrentHashMap<String, Map<String, CONFIG_FILE>>();
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final ObjectMapper mapper = this.buildObjectMapper();
    protected final TenantContextHolder tenantContextHolder;
    protected final String appName;

    public AbstractRefreshableConfiguration(@Value(value="${spring.application.name}") String appName, TenantContextHolder tenantContextHolder) {
        this.tenantContextHolder = tenantContextHolder;
        this.appName = appName;
    }

    public abstract String configName();

    public abstract CONFIG joinTenantConfiguration(List<CONFIG_FILE> var1);

    public abstract JavaType configFileJavaType(TypeFactory var1);

    public ObjectMapper buildObjectMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    public void onUpdate(String tenantKey, CONFIG configuration) {
    }

    public String folder() {
        return "";
    }

    public String configFileExtension() {
        return "yml";
    }

    public List<String> filesPathAntPatterns() {
        String fileExtension = this.configFileExtension();
        String configName = this.configName();
        String folder = this.buildFolderName();
        return List.of("/config/tenants/{tenantName}/" + this.appName + folder + "/" + configName + "/*." + fileExtension);
    }

    public String getTenantVariableName() {
        return TENANT_NAME;
    }

    public String getTenantKey(String filePath, String pattern) {
        return (String)this.pathMatcher.extractUriTemplateVariables(pattern, filePath).get(this.getTenantVariableName());
    }

    protected CONFIG getConfiguration(String tenantKey) {
        return this.configurationsByTenant.get(tenantKey);
    }

    protected Map<String, CONFIG_FILE> getConfigurationFiles() {
        String tenantKey = this.tenantContextHolder.getTenantKey();
        return this.configurationsByTenantByFile.computeIfAbsent(tenantKey, k -> new ConcurrentHashMap());
    }

    public CONFIG getConfiguration() {
        return this.getConfiguration(this.tenantContextHolder.getTenantKey());
    }

    @Override
    public final void onInit(String configKey, String configValue) {
        this.onRefresh(configKey, configValue);
    }

    @Override
    public final void onRefresh(String updatedKey, String config) {
        block7: {
            try {
                String pattern = this.findPattern(updatedKey);
                String tenantKey = this.getTenantKey(updatedKey, pattern);
                Map byFiles = this.configurationsByTenantByFile.computeIfAbsent(tenantKey, k -> new ConcurrentHashMap());
                log.trace("Files state {}", (Object)byFiles);
                if (StringUtils.isBlank((CharSequence)config)) {
                    byFiles.remove(updatedKey);
                    log.info("Configuration by key: {} was removed", (Object)updatedKey);
                } else {
                    Object configurationItem = this.mapper.readValue(config, this.configFileJavaType(this.mapper.getTypeFactory()));
                    byFiles.put(updatedKey, configurationItem);
                    log.info("Configuration by key: {} was updated", (Object)updatedKey);
                }
                CONFIG value = this.joinTenantConfiguration(List.copyOf(byFiles.values()));
                this.onUpdate(tenantKey, value);
                if (value == null) {
                    this.configurationsByTenant.remove(tenantKey);
                    break block7;
                }
                this.configurationsByTenant.put(tenantKey, value);
            }
            catch (Exception e) {
                log.error("Error update configuration by key: {}", (Object)updatedKey, (Object)e);
            }
        }
    }

    private String buildFolderName() {
        Object folder = this.folder();
        folder = folder == null ? "" : folder;
        folder = ((String)folder).startsWith("/") ? folder : "/" + (String)folder;
        folder = ((String)folder).endsWith("/") ? ((String)folder).substring(0, ((String)folder).length() - 1) : folder;
        return folder;
    }

    private String findPattern(String updatedKey) {
        return this.filesPathAntPatterns().stream().filter(pattern -> this.pathMatcher.match(pattern, updatedKey)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported configuration key: " + updatedKey));
    }

    public String buildFilePath(String fileName) {
        return "/config/tenants/" + this.tenantContextHolder.getTenantKey() + "/" + this.appName + this.buildFolderName() + "/" + this.configName() + "/" + fileName + ".yml";
    }

    @Override
    public final boolean isListeningConfiguration(String updatedKey) {
        return this.filesPathAntPatterns().stream().anyMatch(pattern -> this.pathMatcher.match(pattern, updatedKey));
    }
}

