/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.config;

import com.icthh.xm.commons.config.client.api.ConfigService;
import com.icthh.xm.commons.config.client.api.ConfigurationChangedListener;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.domain.Configuration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.AntPathMatcher;

public class InitRefreshableConfigurationBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(InitRefreshableConfigurationBeanPostProcessor.class);
    public static final String LOG_CONFIG_EMPTY = "<CONFIG_EMPTY>";
    private static final String CONFIG_PATH = "/config/tenants/{tenantName}/**";
    private static final String COMMONS = "commons";
    private final ConfigService configService;
    private final Map<String, RefreshableConfiguration> refreshableConfigurations = new HashMap<String, RefreshableConfiguration>();
    private volatile Map<String, Configuration> configMap;
    private final Set<String> includedTenants;
    private final AntPathMatcher matcher = new AntPathMatcher();

    public InitRefreshableConfigurationBeanPostProcessor(ConfigService configService, XmConfigProperties xmConfigProperties) {
        this.configService = configService;
        this.includedTenants = xmConfigProperties.getIncludeTenantUppercase();
        this.addLepCommons();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof RefreshableConfiguration) {
            this.refreshableConfigurations.put(beanName, (RefreshableConfiguration)bean);
            log.info("refreshable configuration bean added: {} = {}", (Object)beanName, bean.getClass());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (this.refreshableConfigurations.containsKey(beanName)) {
            this.initBean(this.refreshableConfigurations.get(beanName), this.getConfig());
        }
        return bean;
    }

    private Map<String, Configuration> getConfig() {
        if (this.configMap == null) {
            this.configMap = this.configService.getConfigurationMap(null);
        }
        return this.configMap;
    }

    private void initBean(final RefreshableConfiguration refreshableConfiguration, Map<String, Configuration> configMap) {
        List<String> initedPaths = this.initConfigPaths(refreshableConfiguration, configMap);
        this.refreshFinished(refreshableConfiguration, initedPaths);
        log.info("refreshable configuration bean [{}] initialized by configMap with {} entries", (Object)InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration), (Object)configMap.size());
        this.configService.addConfigurationChangedListener(new ConfigurationChangedListener(){

            @Override
            public void onConfigurationChanged(Configuration configuration) {
                InitRefreshableConfigurationBeanPostProcessor.this.onEntryChange(refreshableConfiguration, configuration);
            }

            @Override
            public void refreshFinished(Collection<String> paths) {
                List<String> listenPaths = paths.stream().filter(s -> InitRefreshableConfigurationBeanPostProcessor.this.isTenantIncluded((String)s)).filter(refreshableConfiguration::isListeningConfiguration).collect(Collectors.toList());
                if (!listenPaths.isEmpty()) {
                    InitRefreshableConfigurationBeanPostProcessor.this.refreshFinished(refreshableConfiguration, listenPaths);
                }
            }
        });
        refreshableConfiguration.refreshableConfigurationInited();
    }

    public List<String> initConfigPaths(RefreshableConfiguration refreshableConfiguration, Map<String, Configuration> configMap) {
        return configMap.entrySet().stream().filter(e -> this.isTenantIncluded((String)e.getKey())).filter(e -> refreshableConfiguration.isListeningConfiguration((String)e.getKey())).peek(e -> InitRefreshableConfigurationBeanPostProcessor.printLog(InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration), e)).peek(e -> refreshableConfiguration.onInit((String)e.getKey(), ((Configuration)e.getValue()).getContent())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static void printLog(String beanName, Map.Entry<String, Configuration> e) {
        log.info("Process config init event: [key = {}, size = {}, newHash = {}] in bean: [{}]", new Object[]{e.getKey(), StringUtils.length((CharSequence)e.getValue().getContent()), InitRefreshableConfigurationBeanPostProcessor.getValueHash(e.getValue().getContent()), beanName});
    }

    private boolean isTenantIncluded(String configKey) {
        if (!this.includedTenants.isEmpty()) {
            if (this.matcher.match(CONFIG_PATH, configKey)) {
                String tenant = (String)this.matcher.extractUriTemplateVariables(CONFIG_PATH, configKey).get("tenantName");
                return this.includedTenants.contains(tenant);
            }
            return false;
        }
        return true;
    }

    private void addLepCommons() {
        if (!this.includedTenants.isEmpty()) {
            this.includedTenants.add(COMMONS);
        }
    }

    private void refreshFinished(RefreshableConfiguration refreshableConfiguration, Collection<String> paths) {
        try {
            refreshableConfiguration.refreshFinished(paths);
        }
        catch (Exception e) {
            log.error("Error during refresh finished", (Throwable)e);
        }
    }

    private void onEntryChange(RefreshableConfiguration refreshableConfiguration, Configuration configuration) {
        String configContent = configuration.getContent();
        if (this.isTenantIncluded(configuration.getPath())) {
            if (refreshableConfiguration.isListeningConfiguration(configuration.getPath())) {
                refreshableConfiguration.onRefresh(configuration.getPath(), configContent);
                log.info("Process config update event: [path = {}, size = {}, hash = {}] in bean: [{}]", new Object[]{configuration.getPath(), StringUtils.length((CharSequence)configContent), InitRefreshableConfigurationBeanPostProcessor.getValueHash(configContent), InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration)});
            } else {
                log.debug("Ignored config update event: [path = {}, configSize = {} in bean [{}]", new Object[]{configuration.getPath(), StringUtils.length((CharSequence)configContent), InitRefreshableConfigurationBeanPostProcessor.getBeanName(refreshableConfiguration)});
            }
        }
    }

    private static String getBeanName(RefreshableConfiguration refreshableConfiguration) {
        return refreshableConfiguration.getClass().getSimpleName();
    }

    private static String getValueHash(String configContent) {
        return StringUtils.isEmpty((CharSequence)configContent) ? LOG_CONFIG_EMPTY : DigestUtils.md5Hex((String)configContent);
    }
}

