/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.config;

import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"xm-config.enabled"})
@ConfigurationProperties(prefix="xm-config", ignoreUnknownFields=false)
public class XmConfigProperties {
    private Boolean enabled;
    private String xmConfigUrl = "http://config";
    private String tenantConfigPattern;
    private String kafkaConfigTopic = "config_topic";
    private String kafkaConfigQueue = "config_queue";
    private String configMode = "XM_MS_CONFIG";
    private String configDirPath;
    private Integer dirWatchInterval = 500;
    private Set<String> includeTenants;

    public Set<String> getIncludeTenantLowercase() {
        return this.includedTenantsStream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public Set<String> getIncludeTenantUppercase() {
        return this.includedTenantsStream().map(String::toUpperCase).collect(Collectors.toSet());
    }

    private Stream<String> includedTenantsStream() {
        return ((Set)Optional.ofNullable(this.getIncludeTenants()).orElse(new HashSet())).stream();
    }

    public String getDirectoryBasePath() {
        return File.separator + StringUtils.strip((String)this.configDirPath, (String)File.separator);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getXmConfigUrl() {
        return this.xmConfigUrl;
    }

    public String getTenantConfigPattern() {
        return this.tenantConfigPattern;
    }

    public String getKafkaConfigTopic() {
        return this.kafkaConfigTopic;
    }

    public String getKafkaConfigQueue() {
        return this.kafkaConfigQueue;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public String getConfigDirPath() {
        return this.configDirPath;
    }

    public Integer getDirWatchInterval() {
        return this.dirWatchInterval;
    }

    public Set<String> getIncludeTenants() {
        return this.includeTenants;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setXmConfigUrl(String xmConfigUrl) {
        this.xmConfigUrl = xmConfigUrl;
    }

    public void setTenantConfigPattern(String tenantConfigPattern) {
        this.tenantConfigPattern = tenantConfigPattern;
    }

    public void setKafkaConfigTopic(String kafkaConfigTopic) {
        this.kafkaConfigTopic = kafkaConfigTopic;
    }

    public void setKafkaConfigQueue(String kafkaConfigQueue) {
        this.kafkaConfigQueue = kafkaConfigQueue;
    }

    public void setConfigMode(String configMode) {
        this.configMode = configMode;
    }

    public void setConfigDirPath(String configDirPath) {
        this.configDirPath = configDirPath;
    }

    public void setDirWatchInterval(Integer dirWatchInterval) {
        this.dirWatchInterval = dirWatchInterval;
    }

    public void setIncludeTenants(Set<String> includeTenants) {
        this.includeTenants = includeTenants;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmConfigProperties)) {
            return false;
        }
        XmConfigProperties other = (XmConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$dirWatchInterval = this.getDirWatchInterval();
        Integer other$dirWatchInterval = other.getDirWatchInterval();
        if (this$dirWatchInterval == null ? other$dirWatchInterval != null : !((Object)this$dirWatchInterval).equals(other$dirWatchInterval)) {
            return false;
        }
        String this$xmConfigUrl = this.getXmConfigUrl();
        String other$xmConfigUrl = other.getXmConfigUrl();
        if (this$xmConfigUrl == null ? other$xmConfigUrl != null : !this$xmConfigUrl.equals(other$xmConfigUrl)) {
            return false;
        }
        String this$tenantConfigPattern = this.getTenantConfigPattern();
        String other$tenantConfigPattern = other.getTenantConfigPattern();
        if (this$tenantConfigPattern == null ? other$tenantConfigPattern != null : !this$tenantConfigPattern.equals(other$tenantConfigPattern)) {
            return false;
        }
        String this$kafkaConfigTopic = this.getKafkaConfigTopic();
        String other$kafkaConfigTopic = other.getKafkaConfigTopic();
        if (this$kafkaConfigTopic == null ? other$kafkaConfigTopic != null : !this$kafkaConfigTopic.equals(other$kafkaConfigTopic)) {
            return false;
        }
        String this$kafkaConfigQueue = this.getKafkaConfigQueue();
        String other$kafkaConfigQueue = other.getKafkaConfigQueue();
        if (this$kafkaConfigQueue == null ? other$kafkaConfigQueue != null : !this$kafkaConfigQueue.equals(other$kafkaConfigQueue)) {
            return false;
        }
        String this$configMode = this.getConfigMode();
        String other$configMode = other.getConfigMode();
        if (this$configMode == null ? other$configMode != null : !this$configMode.equals(other$configMode)) {
            return false;
        }
        String this$configDirPath = this.getConfigDirPath();
        String other$configDirPath = other.getConfigDirPath();
        if (this$configDirPath == null ? other$configDirPath != null : !this$configDirPath.equals(other$configDirPath)) {
            return false;
        }
        Set<String> this$includeTenants = this.getIncludeTenants();
        Set<String> other$includeTenants = other.getIncludeTenants();
        return !(this$includeTenants == null ? other$includeTenants != null : !((Object)this$includeTenants).equals(other$includeTenants));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XmConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $dirWatchInterval = this.getDirWatchInterval();
        result = result * 59 + ($dirWatchInterval == null ? 43 : ((Object)$dirWatchInterval).hashCode());
        String $xmConfigUrl = this.getXmConfigUrl();
        result = result * 59 + ($xmConfigUrl == null ? 43 : $xmConfigUrl.hashCode());
        String $tenantConfigPattern = this.getTenantConfigPattern();
        result = result * 59 + ($tenantConfigPattern == null ? 43 : $tenantConfigPattern.hashCode());
        String $kafkaConfigTopic = this.getKafkaConfigTopic();
        result = result * 59 + ($kafkaConfigTopic == null ? 43 : $kafkaConfigTopic.hashCode());
        String $kafkaConfigQueue = this.getKafkaConfigQueue();
        result = result * 59 + ($kafkaConfigQueue == null ? 43 : $kafkaConfigQueue.hashCode());
        String $configMode = this.getConfigMode();
        result = result * 59 + ($configMode == null ? 43 : $configMode.hashCode());
        String $configDirPath = this.getConfigDirPath();
        result = result * 59 + ($configDirPath == null ? 43 : $configDirPath.hashCode());
        Set<String> $includeTenants = this.getIncludeTenants();
        result = result * 59 + ($includeTenants == null ? 43 : ((Object)$includeTenants).hashCode());
        return result;
    }

    public String toString() {
        return "XmConfigProperties(enabled=" + this.getEnabled() + ", xmConfigUrl=" + this.getXmConfigUrl() + ", tenantConfigPattern=" + this.getTenantConfigPattern() + ", kafkaConfigTopic=" + this.getKafkaConfigTopic() + ", kafkaConfigQueue=" + this.getKafkaConfigQueue() + ", configMode=" + this.getConfigMode() + ", configDirPath=" + this.getConfigDirPath() + ", dirWatchInterval=" + this.getDirWatchInterval() + ", includeTenants=" + String.valueOf(this.getIncludeTenants()) + ")";
    }
}

