/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.repository;

import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.client.repository.CommonConfigRepository;
import com.icthh.xm.commons.config.domain.Configuration;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;

public class FileCommonConfigRepository
implements CommonConfigRepository {
    private static final IOFileFilter TRUE_FILTER = TrueFileFilter.INSTANCE;
    private final XmConfigProperties xmConfigProperties;

    @Override
    public Map<String, Configuration> getConfig(String commit) {
        File baseDir = new File(this.xmConfigProperties.getDirectoryBasePath());
        Collection listFiles = FileUtils.listFiles((File)new File(baseDir, "config"), (IOFileFilter)TRUE_FILTER, (IOFileFilter)TRUE_FILTER);
        List<String> paths = listFiles.stream().map(File::toPath).map(path -> File.separator + String.valueOf(baseDir.toPath().relativize((Path)path))).toList();
        return this.getConfig(commit, paths);
    }

    @Override
    public Map<String, Configuration> getConfig(String version, Collection<String> paths) {
        File basePath = new File(this.xmConfigProperties.getDirectoryBasePath());
        HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
        for (String relativePath : paths) {
            String content = FileCommonConfigRepository.readFile(basePath, relativePath);
            String path = StringUtils.replaceChars((String)relativePath, (String)File.separator, (String)"/");
            configurationMap.put(path, new Configuration(path, content));
        }
        return configurationMap;
    }

    private static String readFile(File basePath, String relativePath) {
        File file = new File(basePath, relativePath);
        if (file.exists()) {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void updateConfigFullPath(Configuration configuration, String oldConfigHash) {
        File file = new File(this.xmConfigProperties.getDirectoryBasePath(), configuration.getPath());
        FileUtils.writeStringToFile((File)file, (String)configuration.getContent(), (Charset)StandardCharsets.UTF_8);
    }

    public FileCommonConfigRepository(XmConfigProperties xmConfigProperties) {
        this.xmConfigProperties = xmConfigProperties;
    }
}

