/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.repository;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.client.repository.CommonConfigRepository;
import com.icthh.xm.commons.config.client.utils.RequestUtils;
import com.icthh.xm.commons.config.domain.Configuration;
import com.icthh.xm.commons.config.domain.TenantState;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TenantListRepository
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TenantListRepository.class);
    public static final String TENANTS_LIST_CONFIG_KEY = "/config/tenants/tenants-list.json";
    private static final String URL = "/api/tenants/";
    private static final String ERROR = "Tenant list not found. Maybe xm-config not running.";
    private static final String SUSPENDED_STATE = "SUSPENDED";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final RestTemplate restTemplate;
    private final String applicationName;
    private final String xmConfigUrl;
    private final Set<String> includeTenants;
    private volatile Set<TenantState> tenants = new HashSet<TenantState>();
    private volatile Set<String> suspendedTenants = new HashSet<String>();

    public TenantListRepository(RestTemplate restTemplate, Configuration configuration, String applicationName, XmConfigProperties xmConfigProperties) {
        this.restTemplate = restTemplate;
        this.applicationName = applicationName;
        this.xmConfigUrl = xmConfigProperties.getXmConfigUrl() + URL;
        this.includeTenants = xmConfigProperties.getIncludeTenantLowercase();
        this.checkAndInit(configuration);
    }

    public TenantListRepository(RestTemplate restTemplate, CommonConfigRepository commonConfigRepository, String applicationName, XmConfigProperties xmConfigProperties) {
        this.restTemplate = restTemplate;
        this.applicationName = applicationName;
        this.xmConfigUrl = xmConfigProperties.getXmConfigUrl() + URL;
        this.includeTenants = xmConfigProperties.getIncludeTenantLowercase();
        Configuration configuration = commonConfigRepository.getConfig(null, Collections.singletonList(TENANTS_LIST_CONFIG_KEY)).get(TENANTS_LIST_CONFIG_KEY);
        this.checkAndInit(configuration);
    }

    private void checkAndInit(Configuration configuration) {
        if (configuration == null) {
            log.error(ERROR);
            throw new IllegalStateException(ERROR);
        }
        this.onInit(TENANTS_LIST_CONFIG_KEY, configuration.getContent());
    }

    public Set<String> getTenants() {
        if (CollectionUtils.isEmpty(this.tenants)) {
            log.error(ERROR);
            throw new IllegalStateException(ERROR);
        }
        return Collections.unmodifiableSet(this.tenants.stream().map(TenantState::getName).collect(Collectors.toSet()));
    }

    public Set<String> getSuspendedTenants() {
        return Collections.unmodifiableSet(this.suspendedTenants);
    }

    public void addTenant(String tenantName) {
        HttpEntity entity = new HttpEntity((Object)tenantName.toLowerCase(), (MultiValueMap)RequestUtils.createAuthHeaders());
        this.restTemplate.postForEntity(this.xmConfigUrl + this.applicationName, (Object)entity, Void.class, new Object[0]);
    }

    public void deleteTenant(String tenantName) {
        HttpEntity entity = new HttpEntity((MultiValueMap)RequestUtils.createAuthHeaders());
        this.restTemplate.exchange(this.xmConfigUrl + this.applicationName + "/" + tenantName.toLowerCase(), HttpMethod.DELETE, entity, Void.class, new Object[0]);
    }

    public void updateTenant(String tenantName, String state) {
        HttpEntity entity = new HttpEntity((Object)state, (MultiValueMap)RequestUtils.createAuthHeaders());
        this.restTemplate.exchange(this.xmConfigUrl + this.applicationName + "/" + tenantName.toLowerCase(), HttpMethod.PUT, entity, Void.class, new Object[0]);
    }

    private void updateTenants(String key, String config) {
        log.info("Tenants list was updated");
        if (!TENANTS_LIST_CONFIG_KEY.equals(key)) {
            throw new IllegalArgumentException("Wrong config key to update " + key);
        }
        this.assertExistsTenantsListConfig(config);
        Set<TenantState> tenantKeys = TenantListRepository.parseTenantStates(config, this.applicationName, this.objectMapper);
        this.assertExistTenants(tenantKeys);
        if (!this.includeTenants.isEmpty()) {
            log.warn("Tenant list was overridden by property 'xm-config.include-tenants' to: {}", this.includeTenants);
        }
        this.tenants = tenantKeys.stream().filter(TenantListRepository.isIncluded(this.includeTenants)).collect(Collectors.toSet());
        this.suspendedTenants = tenantKeys.stream().filter(TenantListRepository.isSuspended()).map(TenantState::getName).collect(Collectors.toSet());
    }

    public static Predicate<TenantState> isIncluded(Set<String> includedTenants) {
        return tenantState -> includedTenants == null || includedTenants.isEmpty() || includedTenants.contains(tenantState.getName());
    }

    public static Predicate<TenantState> isSuspended() {
        return tenantState -> SUSPENDED_STATE.equals(tenantState.getState());
    }

    private static Set<TenantState> parseTenantStates(String tenantListJson, String appName, ObjectMapper mapper) throws IOException {
        return TenantListRepository.parseTenantStates(tenantListJson, mapper).get(appName);
    }

    public static Map<String, Set<TenantState>> parseTenantStates(String tenantListJson, ObjectMapper mapper) throws IOException {
        CollectionType setType = TypeFactory.defaultInstance().constructCollectionType(HashSet.class, TenantState.class);
        MapType type = TypeFactory.defaultInstance().constructMapType(HashMap.class, TypeFactory.defaultInstance().constructType(String.class), (JavaType)setType);
        Map map = (Map)mapper.readValue(tenantListJson, (JavaType)type);
        return Optional.ofNullable(map).orElse(new HashMap());
    }

    private void assertExistTenants(Set<TenantState> tenantKeys) {
        if (CollectionUtils.isEmpty(tenantKeys)) {
            String error = "Tenant list for " + this.applicationName + " empty. Check tenants-list.json.";
            log.error(error);
            throw new IllegalStateException(error);
        }
    }

    private void assertExistsTenantsListConfig(String config) {
        if (StringUtils.isBlank((CharSequence)config)) {
            log.error(ERROR);
            throw new IllegalStateException(ERROR);
        }
    }

    @Override
    public void onRefresh(String key, String config) {
        this.updateTenants(key, config);
    }

    @Override
    public boolean isListeningConfiguration(String updatedKey) {
        return TENANTS_LIST_CONFIG_KEY.equals(updatedKey);
    }

    @Override
    public void onInit(String key, String config) {
        this.updateTenants(key, config);
    }
}

