/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.repository.CommonConfigRepository;
import com.icthh.xm.commons.config.client.repository.TenantListRepository;
import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.config.domain.Configuration;
import com.icthh.xm.commons.config.domain.TenantAliasTree;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAliasServiceImpl
implements TenantAliasService {
    private static final Logger log = LoggerFactory.getLogger(TenantAliasServiceImpl.class);
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private volatile TenantAliasTree tenantAliasTree = new TenantAliasTree();

    public TenantAliasServiceImpl(CommonConfigRepository commonConfigRepository, TenantListRepository tenantListRepository) {
        Objects.requireNonNull(tenantListRepository, "tenantListRepository can't be null");
        Map configMap = commonConfigRepository.getConfig(null, Collections.singletonList("/config/tenants/tenant-aliases.yml"));
        configMap = (Map)ObjectUtils.firstNonNull((Object[])new Map[]{configMap, Collections.emptyMap()});
        Configuration configuration = (Configuration)configMap.get("/config/tenants/tenant-aliases.yml");
        if (configuration != null && StringUtils.isNotBlank((CharSequence)configuration.getContent())) {
            this.onRefresh(configuration.getContent());
        } else {
            log.info("Tenant aliases not configured.");
        }
    }

    @Override
    public void onRefresh(String config) {
        try {
            TenantAliasTree tenantAliasTree = (TenantAliasTree)this.mapper.readValue(config, TenantAliasTree.class);
            tenantAliasTree.init();
            this.tenantAliasTree = tenantAliasTree;
            log.info("Tenant aliases inited");
            log.trace("Tenant aliases inited: {}", (Object)config);
        }
        catch (IOException e) {
            log.error("Error parse tenant alias config", (Throwable)e);
        }
    }

    @Override
    public TenantAliasTree getTenantAliasTree() {
        return this.tenantAliasTree;
    }
}

