/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.utils;

import com.icthh.xm.commons.security.internal.XmAuthentication;
import com.icthh.xm.commons.security.internal.XmAuthenticationDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public final class TokenUtils {
    public static String extractCurrentToken() {
        XmAuthentication auth = TokenUtils.getAuthentication();
        if (auth == null) {
            throw new IllegalStateException("Cannot get current authentication object");
        }
        XmAuthenticationDetails details = auth.getDetails();
        if (details == null) {
            return null;
        }
        return details.getTokenValue();
    }

    private static XmAuthentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof XmAuthentication) {
            XmAuthentication xmAuthentication = (XmAuthentication)auth;
            return xmAuthentication;
        }
        return null;
    }

    private TokenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

