/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.config;

import com.icthh.xm.commons.config.client.config.XmTimeoutProperties;
import com.icthh.xm.commons.config.client.exception.ConflictUpdateConfigException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(value={"xm-config.enabled"})
@EnableConfigurationProperties(value={XmTimeoutProperties.class})
public class XmRestTemplateConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XmRestTemplateConfiguration.class);
    public static final String XM_CONFIG_REST_TEMPLATE = "xm-config-rest-template";

    private static RestTemplate createRestTemplate(RestTemplateBuilder restTemplateBuilder, ObjectProvider<XmTimeoutProperties> xmTimeoutPropertiesProvider) {
        XmTimeoutProperties timeoutProperties = (XmTimeoutProperties)xmTimeoutPropertiesProvider.getIfAvailable();
        if (Objects.nonNull(timeoutProperties) && ObjectUtils.anyNotNull((Object[])new Object[]{timeoutProperties.getConnectionTimeout(), timeoutProperties.getReadTimeout()})) {
            log.info("createRestTemplate applying timeouts={}", (Object)timeoutProperties);
            restTemplateBuilder.setConnectTimeout(timeoutProperties.getConnectionTimeout()).setReadTimeout(timeoutProperties.getReadTimeout());
        }
        RestTemplate restTemplate = restTemplateBuilder.build();
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                if (response.getStatusCode() == HttpStatus.CONFLICT) {
                    throw new ConflictUpdateConfigException();
                }
                super.handleError(response);
            }
        });
        return restTemplate;
    }

    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.enabled"}, havingValue="false")
    static class XmPlainRestTemplateConfiguration {
        XmPlainRestTemplateConfiguration() {
        }

        @Bean(value={"xm-config-rest-template"})
        public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder, ObjectProvider<XmTimeoutProperties> xmTimeoutPropertiesProvider) {
            log.info("restTemplate without loadBalancer");
            return XmRestTemplateConfiguration.createRestTemplate(restTemplateBuilder, xmTimeoutPropertiesProvider);
        }
    }

    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.enabled"}, havingValue="true", matchIfMissing=true)
    static class XmLoadBalancerRestTemplateConfiguration {
        XmLoadBalancerRestTemplateConfiguration() {
        }

        @Bean(value={"xm-config-rest-template"})
        public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder, RestTemplateCustomizer customizer, ObjectProvider<XmTimeoutProperties> xmTimeoutPropertiesProvider) {
            log.info("restTemplate with loadBalancer");
            RestTemplate restTemplate = XmRestTemplateConfiguration.createRestTemplate(restTemplateBuilder, xmTimeoutPropertiesProvider);
            customizer.customize(restTemplate);
            return restTemplate;
        }
    }
}

