/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.repository;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.client.repository.CommonConfigRepository;
import com.icthh.xm.commons.config.client.repository.message.ConfigurationUpdateMessage;
import com.icthh.xm.commons.config.client.repository.message.GetConfigRequest;
import com.icthh.xm.commons.config.client.utils.RequestUtils;
import com.icthh.xm.commons.config.domain.ConfigQueueEvent;
import com.icthh.xm.commons.config.domain.Configuration;
import com.icthh.xm.commons.config.domain.enums.ConfigEventType;
import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class XmMsConfigCommonConfigRepository
implements CommonConfigRepository {
    private static final Logger log = LoggerFactory.getLogger(XmMsConfigCommonConfigRepository.class);
    @Value(value="${application.tenant-with-creation-access-list:#{T(java.util.Set).of('XM')}}")
    private Set<String> allowedTenants;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static final String URL = "/api/private";
    private static final String VERSION = "version";
    private static final String TENANT_NAME = "tenantName";
    private static final String TENANT_PATH = "/config/tenants/{tenantName}/*/**";
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final RestTemplate restTemplate;
    private final XmConfigProperties xmConfigProperties;
    private final KafkaTemplate<String, String> kafkaTemplate;
    private final TenantContextHolder tenantContextHolder;
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule());

    @Override
    public Map<String, Configuration> getConfig(String commit) {
        ParameterizedTypeReference<Map<String, Configuration>> typeRef = new ParameterizedTypeReference<Map<String, Configuration>>(this){};
        HttpEntity entity = new HttpEntity((MultiValueMap)RequestUtils.createSimpleHeaders());
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(this.getServiceConfigUrl() + "/config_map")).queryParam(VERSION, new Object[]{commit});
        return (Map)this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, entity, (ParameterizedTypeReference)typeRef, new Object[0]).getBody();
    }

    private String getServiceConfigUrl() {
        return this.xmConfigProperties.getXmConfigUrl() + URL;
    }

    @Override
    public Map<String, Configuration> getConfig(String version, Collection<String> paths) {
        ParameterizedTypeReference<Map<String, Configuration>> typeRef = new ParameterizedTypeReference<Map<String, Configuration>>(this){};
        HttpEntity entity = new HttpEntity((Object)new GetConfigRequest(version, paths), (MultiValueMap)RequestUtils.createApplicationJsonHeaders());
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(this.getServiceConfigUrl() + "/config_map"));
        return (Map)this.restTemplate.exchange(builder.toUriString(), HttpMethod.POST, entity, (ParameterizedTypeReference)typeRef, new Object[0]).getBody();
    }

    @Override
    public void updateConfigFullPath(Configuration configuration, String oldConfigHash) {
        String tenantKey = this.getValidatedTenantKey(configuration.getPath());
        String topicName = this.xmConfigProperties.getKafkaConfigQueue();
        ConfigurationUpdateMessage message = new ConfigurationUpdateMessage(configuration, oldConfigHash);
        log.info("Sending update configuration message event to kafka-topic = '{}', data = '{}'", (Object)topicName, (Object)message);
        this.kafkaTemplate.send(topicName, (Object)this.buildSystemEvent(message, tenantKey));
    }

    private String getValidatedTenantKey(String configurationPath) {
        String pathTenantKey;
        if (!this.pathMatcher.match(TENANT_PATH, configurationPath)) {
            throw new BusinessException("Updating files beyond tenant is forbidden");
        }
        String contextTenantKey = this.tenantContextHolder.getTenantKey();
        if (!StringUtils.equals((CharSequence)contextTenantKey, (CharSequence)(pathTenantKey = (String)this.pathMatcher.extractUriTemplateVariables(TENANT_PATH, configurationPath).get(TENANT_NAME))) && !this.allowedTenants.contains(contextTenantKey)) {
            throw new BusinessException(String.format("Current configuration update is not allowed for tenant %s. Check your current tenant or a list of tenants with creation access.", pathTenantKey));
        }
        return pathTenantKey;
    }

    private String buildSystemEvent(ConfigurationUpdateMessage message, String tenantKey) {
        return this.toJson(ConfigQueueEvent.builder().eventId(MdcUtils.getRid()).messageSource(this.applicationName).eventType(ConfigEventType.UPDATE_CONFIG.name()).tenantKey(tenantKey).startDate(Instant.now()).data(message).build());
    }

    private String toJson(ConfigQueueEvent event) {
        return this.mapper.writeValueAsString((Object)event);
    }

    public XmMsConfigCommonConfigRepository(RestTemplate restTemplate, XmConfigProperties xmConfigProperties, KafkaTemplate<String, String> kafkaTemplate, TenantContextHolder tenantContextHolder) {
        this.restTemplate = restTemplate;
        this.xmConfigProperties = xmConfigProperties;
        this.kafkaTemplate = kafkaTemplate;
        this.tenantContextHolder = tenantContextHolder;
    }
}

