/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.repository.file;

import com.icthh.xm.commons.config.client.api.ConfigService;
import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class FileUpdateWatcher
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(FileUpdateWatcher.class);
    public static final String MS_CONFIG_SEPARATOR = "/";
    private final FileAlterationMonitor monitor;
    private final ConfigService configService;

    public FileUpdateWatcher(ConfigService configService, XmConfigProperties xmConfigProperties) {
        this.configService = configService;
        this.monitor = this.createFileWatcher(xmConfigProperties);
        this.monitor.start();
    }

    private FileAlterationMonitor createFileWatcher(final XmConfigProperties xmConfigProperties) {
        FileAlterationObserver observer = new FileAlterationObserver(new File(xmConfigProperties.getConfigDirPath()));
        observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                FileUpdateWatcher.this.updateFile(xmConfigProperties, file);
            }

            public void onFileChange(File file) {
                FileUpdateWatcher.this.updateFile(xmConfigProperties, file);
            }

            public void onFileDelete(File file) {
                FileUpdateWatcher.this.updateFile(xmConfigProperties, file);
            }
        });
        return new FileAlterationMonitor((long)xmConfigProperties.getDirWatchInterval().intValue(), new FileAlterationObserver[]{observer});
    }

    public void updateFile(XmConfigProperties xmConfigProperties, File file) {
        List<String> configs = Optional.ofNullable(xmConfigProperties).map(XmConfigProperties::getConfigDirPath).map(String::length).map(length -> file.getAbsolutePath().substring((int)length)).map(configPath -> StringUtils.replaceChars((String)configPath, (String)File.separator, (String)MS_CONFIG_SEPARATOR)).map(configPath -> StringUtils.prependIfMissing((String)configPath, (CharSequence)MS_CONFIG_SEPARATOR, (CharSequence[])new CharSequence[0])).stream().toList();
        this.configService.updateConfigurations("" + System.currentTimeMillis(), configs);
    }

    public void destroy() throws Exception {
        this.monitor.stop();
    }
}

