/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAliasTree {
    private static final Logger log = LoggerFactory.getLogger(TenantAliasTree.class);
    private List<TenantAlias> tenantAliasTree = Collections.emptyList();
    @JsonIgnore
    private Map<String, TenantAlias> tenants = Collections.emptyMap();
    @JsonIgnore
    private Map<String, List<TenantAlias>> parents = Collections.emptyMap();

    public void init() {
        this.tenantAliasTree = Collections.unmodifiableList(this.tenantAliasTree);
        this.tenants = Collections.unmodifiableMap(this.tenants());
        this.parents = Collections.unmodifiableMap(this.parents());
    }

    public List<TenantAlias> getParents(String tenant) {
        return this.parents.getOrDefault(tenant, Collections.emptyList());
    }

    public List<String> getParentKeys(String tenant) {
        return this.getParents(tenant).stream().map(TenantAlias::getKey).collect(Collectors.toList());
    }

    public List<String> getAllChildrenRecursive(String tenant) {
        TenantAlias tenantAlias = this.tenants.get(tenant);
        ArrayList<String> childTenant = new ArrayList<String>(List.of(tenant));
        if (tenantAlias != null) {
            tenantAlias.traverseChild((current, child) -> {
                childTenant.add(child.getKey());
                return TraverseRule.CONTINUE;
            });
        }
        return childTenant;
    }

    public void traverse(BiFunction<TenantAlias, TenantAlias, TraverseRule> operation) {
        List<TenantAlias> tree = Objects.requireNonNullElse(this.tenantAliasTree, Collections.emptyList());
        tree.forEach(node -> node.traverseChild(operation));
    }

    private Map<String, List<TenantAlias>> parents() {
        HashMap<String, List<TenantAlias>> parents = new HashMap<String, List<TenantAlias>>();
        this.traverse((parent, child) -> this.initParentField((Map<String, List<TenantAlias>>)parents, (TenantAlias)parent, (TenantAlias)child));
        return parents;
    }

    private TraverseRule initParentField(Map<String, List<TenantAlias>> parents, TenantAlias parent, TenantAlias child) {
        child.parent = parent;
        ArrayList<TenantAlias> parentsList = new ArrayList<TenantAlias>();
        TenantAlias currentNode = child;
        while (currentNode.parent != null) {
            parentsList.add(currentNode.parent);
            currentNode = currentNode.parent;
        }
        parents.put(child.getKey(), parentsList);
        return TraverseRule.CONTINUE;
    }

    private Map<String, TenantAlias> tenants() {
        HashMap<String, TenantAlias> tenants = new HashMap<String, TenantAlias>();
        this.traverse((parent, child) -> this.consumeTenants((Map<String, TenantAlias>)tenants, (TenantAlias)parent, (TenantAlias)child));
        return tenants;
    }

    private TraverseRule consumeTenants(Map<String, TenantAlias> tenants, TenantAlias parent, TenantAlias child) {
        tenants.put(parent.getKey(), parent);
        if (tenants.containsKey(child.getKey())) {
            log.error("Key {} present twice in tenant alias configuration", (Object)child.getKey());
            throw new WrongTenantAliasConfiguration(child.getKey() + " present twice in tenant alias configuration");
        }
        tenants.put(child.getKey(), child);
        return TraverseRule.CONTINUE;
    }

    public List<TenantAlias> getTenantAliasTree() {
        return this.tenantAliasTree;
    }

    public void setTenantAliasTree(List<TenantAlias> tenantAliasTree) {
        this.tenantAliasTree = tenantAliasTree;
    }

    public Map<String, TenantAlias> getTenants() {
        return this.tenants;
    }

    public static class TenantAlias {
        private String key;
        private List<TenantAlias> children;
        @JsonIgnore
        private TenantAlias parent;

        public void traverseChild(BiFunction<TenantAlias, TenantAlias, TraverseRule> operation) {
            List<TenantAlias> children = Objects.requireNonNullElse(this.children, Collections.emptyList());
            for (TenantAlias child : children) {
                TraverseRule rule = operation.apply(this, child);
                if (rule != TraverseRule.CONTINUE) continue;
                child.traverseChild(operation);
            }
        }

        public String getKey() {
            return this.key;
        }

        public List<TenantAlias> getChildren() {
            return this.children;
        }

        public TenantAlias getParent() {
            return this.parent;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setChildren(List<TenantAlias> children) {
            this.children = children;
        }

        @JsonIgnore
        public void setParent(TenantAlias parent) {
            this.parent = parent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TenantAlias)) {
                return false;
            }
            TenantAlias other = (TenantAlias)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            List<TenantAlias> this$children = this.getChildren();
            List<TenantAlias> other$children = other.getChildren();
            if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
                return false;
            }
            TenantAlias this$parent = this.getParent();
            TenantAlias other$parent = other.getParent();
            return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TenantAlias;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            List<TenantAlias> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            TenantAlias $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            return result;
        }

        public String toString() {
            return "TenantAliasTree.TenantAlias(key=" + this.getKey() + ", parent=" + String.valueOf(this.getParent()) + ")";
        }
    }

    public static enum TraverseRule {
        BREAK,
        CONTINUE;

    }

    public static class WrongTenantAliasConfiguration
    extends RuntimeException {
        public WrongTenantAliasConfiguration(String message) {
            super(message);
        }
    }
}

