/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectMapperUtils {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperUtils.class);
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static Map<String, Object> deserializeToMap(String data) {
        try {
            return StringUtils.isBlank((CharSequence)data) ? new HashMap<String, Object>() : (Map)jsonMapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            log.warn("Error during String to JSON converting", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static <S> Optional<S> readSpecYml(String tenant, String config, Class<S> specType) {
        try {
            return Optional.ofNullable(ymlMapper.readValue(config, specType));
        }
        catch (JsonProcessingException e) {
            log.debug("Could not read specification for tenant: {}", (Object)tenant, (Object)e);
            return Optional.empty();
        }
    }

    private ObjectMapperUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

