/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.listener;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class JsonListenerService {
    private final Map<String, Map<String, String>> tenantsSpecificationsByPath = new LinkedHashMap<String, Map<String, String>>();

    public void processTenantSpecification(String tenantName, String relativePath, String config) {
        if (!StringUtils.isBlank((CharSequence)relativePath)) {
            Map relativePathSpecMap = this.tenantsSpecificationsByPath.computeIfAbsent(tenantName, t -> new ConcurrentHashMap());
            if (StringUtils.isBlank((CharSequence)config)) {
                relativePathSpecMap.remove(relativePath);
            } else {
                relativePathSpecMap.put(relativePath, config);
            }
        }
    }

    public String getSpecificationByTenantRelativePath(String tenant, String relativePath) {
        if (relativePath == null) {
            return "";
        }
        return Optional.ofNullable(this.getSpecificationByTenant(tenant)).map(spec -> (String)spec.get(relativePath)).orElse("");
    }

    public Map<String, String> getSpecificationByTenant(String tenant) {
        return this.tenantsSpecificationsByPath.get(tenant);
    }
}

