/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.processor.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.icthh.xm.commons.domain.FormSpec;
import com.icthh.xm.commons.listener.JsonListenerService;
import com.icthh.xm.commons.processor.SpecProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="formSpecProcessor")
public class FormSpecProcessor
extends SpecProcessor<FormSpec> {
    private static final Logger log = LoggerFactory.getLogger(FormSpecProcessor.class);
    private final Map<String, Map<String, Map<String, FormSpec>>> formsByTenant = new ConcurrentHashMap<String, Map<String, Map<String, FormSpec>>>();

    public FormSpecProcessor(JsonListenerService jsonListenerService) {
        super(jsonListenerService);
    }

    @Override
    public String getSectionName() {
        return "xmForm";
    }

    @Override
    public String getReferencePattern() {
        return "#/" + this.getSectionName() + "/**/*";
    }

    @Override
    public String getKeyTemplate() {
        return this.getKeyTemplatePrefix() + "{formKey}";
    }

    private String getKeyTemplatePrefix() {
        return "#/" + this.getSectionName() + "/";
    }

    @Override
    public void fullUpdateStateByTenant(String tenant, String baseSpecKey, Collection<FormSpec> formSpecs) {
        Map<String, FormSpec> allForms = this.toKeyMapOverrideDuplicates(formSpecs);
        if (!allForms.isEmpty()) {
            log.info("added {} form specs to tenant: {}", (Object)allForms.size(), (Object)tenant);
            this.formsByTenant.computeIfAbsent(tenant, s -> new HashMap()).put(baseSpecKey, allForms);
        }
    }

    @Override
    public void processDataSpec(String tenant, String baseSpecKey, Consumer<String> setter, Supplier<String> getter) {
        String typeSpecForm = getter.get();
        if (StringUtils.isBlank((CharSequence)typeSpecForm) || this.formsByTenant.getOrDefault(tenant, Map.of()).isEmpty()) {
            return;
        }
        String updatedSpecForm = typeSpecForm;
        for (int i = 0; i < 10; ++i) {
            Set<String> existingReferences = this.findDataSpecReferencesByPattern(updatedSpecForm, this.getReferencePattern());
            if (existingReferences.isEmpty()) {
                setter.accept(updatedSpecForm);
                return;
            }
            Map<String, String> specifications = this.collectTenantSpecifications(existingReferences, tenant, baseSpecKey);
            updatedSpecForm = this.resolveReferences(specifications, updatedSpecForm);
        }
        log.warn("Max iteration limit reached: {}. Skip current form processing", (Object)10);
    }

    private Map<String, String> collectTenantSpecifications(Set<String> existingReferences, String tenant, String baseSpecKey) {
        LinkedHashMap<String, String> specificationsByRelativePath = new LinkedHashMap<String, String>();
        for (String formPath : existingReferences) {
            String formKey = (String)this.matcher.extractUriTemplateVariables(this.getKeyTemplate(), formPath).get("formKey");
            if (formKey.isBlank()) continue;
            Optional.ofNullable((Map)this.formsByTenant.getOrDefault(tenant, Map.of()).get(baseSpecKey)).map(formMap -> (FormSpec)formMap.get(formKey)).map(formSpec -> this.getFormSpecificationByFile(tenant, (FormSpec)formSpec)).filter(StringUtils::isNotBlank).ifPresentOrElse(specification -> specificationsByRelativePath.put(this.getKeyTemplatePrefix() + formKey, (String)specification), () -> log.warn("The form specification for key:{} and tenant:{} was not found.", (Object)formKey, (Object)tenant));
        }
        return specificationsByRelativePath;
    }

    private String getFormSpecificationByFile(String tenant, FormSpec formSpec) {
        return Optional.ofNullable(formSpec.getValue()).orElseGet(() -> this.jsonListenerService.getSpecificationByTenantRelativePath(tenant, formSpec.getRef()));
    }

    private String resolveReferences(Map<String, String> specifications, String formSpec) {
        JsonNode defaults = (JsonNode)this.jsonMapper.readValue(formSpec, JsonNode.class);
        JsonNode jsonNode = this.replaceReferences(defaults, specifications, null);
        return this.jsonMapper.writeValueAsString((Object)jsonNode);
    }

    private JsonNode replaceReferences(JsonNode node, Map<String, String> specifications, ContainerNode<?> parentNode) {
        if (node.isObject()) {
            this.replaceReferencesFromObject(node, specifications, parentNode);
        } else if (node.isArray()) {
            this.replaceReferencesFromArray(node, specifications, parentNode);
        }
        return node;
    }

    private JsonNode replaceReferencesFromObject(JsonNode node, Map<String, String> specifications, ContainerNode<?> parentNode) {
        ObjectNode objectNode = (ObjectNode)node;
        Map<String, JsonNode> objectMap = this.copyToMap(objectNode.fields());
        JsonNode refNode = objectMap.get("$ref");
        JsonNode keyNode = objectMap.getOrDefault("key", (JsonNode)this.ymlMapper.createObjectNode());
        objectNode.remove("$ref");
        if (refNode != null && objectNode.size() == 1) {
            objectNode.remove("key");
        }
        String refPath = ((JsonNode)MoreObjects.firstNonNull((Object)refNode, (Object)this.ymlMapper.createObjectNode())).asText();
        String formSpec = specifications.getOrDefault(refPath, "{}");
        ContainerNode<?> fromSpecNode = this.convertSpecificationToObjectNodes(formSpec, refPath);
        this.processFromSpecNode((JsonNode)fromSpecNode, keyNode.asText());
        this.injectJsonNode(parentNode, objectNode, fromSpecNode, refPath);
        objectMap.values().forEach(childNode -> this.replaceReferences((JsonNode)childNode, specifications, (ContainerNode<?>)objectNode));
        return node;
    }

    private JsonNode replaceReferencesFromArray(JsonNode node, Map<String, String> specifications, ContainerNode<?> parentNode) {
        ArrayList copiedList = Lists.newArrayList((Iterator)node.iterator());
        for (JsonNode jsonNode : copiedList) {
            this.replaceReferences(jsonNode, specifications, (ContainerNode<?>)((ArrayNode)node));
        }
        return node;
    }

    private Map<String, JsonNode> copyToMap(Iterator<Map.Entry<String, JsonNode>> iterator) {
        LinkedHashMap<String, JsonNode> jsonNodeMap = new LinkedHashMap<String, JsonNode>();
        iterator.forEachRemaining(entry -> jsonNodeMap.put((String)entry.getKey(), (JsonNode)entry.getValue()));
        return jsonNodeMap;
    }

    private ContainerNode<?> convertSpecificationToObjectNodes(String specification, String ref) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (ContainerNode)objectMapper.readValue(specification, ContainerNode.class);
        }
        catch (JsonProcessingException e) {
            log.error("The form specification by ref: {} could not be processed. Error: {}", (Object)ref, (Object)e.getMessage());
            throw e;
        }
    }

    private void processFromSpecNode(JsonNode fromSpecNode, String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return;
        }
        if (fromSpecNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)fromSpecNode;
            Map<String, JsonNode> objectMap = this.copyToMap(objectNode.fields());
            JsonNode keyNode = objectMap.get("key");
            if (keyNode != null) {
                objectNode.put("key", prefix + "." + keyNode.asText());
            } else if (objectMap.containsKey("$ref")) {
                objectNode.put("key", prefix);
            }
            objectMap.values().forEach(it -> this.processFromSpecNode((JsonNode)it, prefix));
        } else if (fromSpecNode.isArray()) {
            ArrayList copiedList = Lists.newArrayList((Iterator)fromSpecNode.iterator());
            for (JsonNode jsonNode : copiedList) {
                this.processFromSpecNode(jsonNode, prefix);
            }
        }
    }

    private void injectJsonNode(ContainerNode<?> parentNode, ObjectNode objectNode, ContainerNode<?> jsonNode, String refPath) {
        if (jsonNode.isArray() && parentNode.isObject()) {
            log.warn("Array by $ref {} has been injected to the object instead of array.", (Object)refPath);
        } else if (jsonNode.isArray() && parentNode.isArray()) {
            this.processArrayNode((ArrayNode)jsonNode, (ArrayNode)parentNode, objectNode);
        } else {
            objectNode.setAll((ObjectNode)jsonNode);
            FormSpecProcessor.removeEmptyObject(parentNode, objectNode);
        }
    }

    private void processArrayNode(ArrayNode arrayNode, ArrayNode parentArray, ObjectNode objectNode) {
        ArrayList arrayNodesList = Lists.newArrayList((Iterator)arrayNode.iterator());
        ArrayList newParentArray = Lists.newArrayList((Iterator)parentArray.elements());
        int index = FormSpecProcessor.indexOfByReference(objectNode, newParentArray);
        newParentArray.addAll(index + 1, arrayNodesList);
        if (objectNode.isEmpty()) {
            newParentArray.remove(objectNode);
        }
        parentArray.removeAll();
        parentArray.addAll((Collection)newParentArray);
    }

    private static int indexOfByReference(ObjectNode objectNode, List<JsonNode> list) {
        return IntStream.range(0, list.size()).filter(i -> objectNode == list.get(i)).findFirst().orElse(-1);
    }

    private static void removeEmptyObject(ContainerNode<?> parentNode, ObjectNode objectNode) {
        if (parentNode != null && parentNode.isArray() && objectNode.isEmpty()) {
            ArrayList elements = Lists.newArrayList((Iterator)parentNode.elements());
            elements.remove(FormSpecProcessor.indexOfByReference(objectNode, elements));
            parentNode.removeAll();
            ((ArrayNode)parentNode).addAll((Collection)elements);
        }
    }
}

