/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.db.config;

import com.icthh.xm.commons.domainevent.db.service.DatabaseSourceInterceptor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"application.domain-event.enabled"}, havingValue="true")
public class DatabaseSourceInterceptorCustomizer
implements HibernatePropertiesCustomizer {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSourceInterceptorCustomizer.class);
    public static final String SESSION_FACTORY_INTERCEPTOR_PROPERTY = "hibernate.session_factory.interceptor";
    private final DatabaseSourceInterceptor databaseSourceInterceptor;

    public DatabaseSourceInterceptorCustomizer(@Lazy DatabaseSourceInterceptor databaseSourceInterceptor) {
        this.databaseSourceInterceptor = databaseSourceInterceptor;
    }

    public void customize(Map<String, Object> hibernateProperties) {
        hibernateProperties.put(SESSION_FACTORY_INTERCEPTOR_PROPERTY, (Object)this.databaseSourceInterceptor);
        log.info("DatabaseSourceInterceptor is enabled");
    }
}

