/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.db.listener;

import com.icthh.xm.commons.domainevent.db.service.kafka.SystemQueueConsumer;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.permission.inspector.PrivilegeInspector;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.stereotype.Component;

@Component(value="dbDomainEventAppStartApp")
@ConditionalOnProperty(value={"application.auto-system-queue-enabled"}, havingValue="true")
public class ApplicationStartup
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationStartup.class);
    @Value(value="${application.kafka-system-queue}")
    private String kafkaSystemQueue;
    @Value(value="${application.kafka-metadata-max-age}")
    private Integer kafkaMetadataMaxAge;
    private final SystemQueueConsumer systemQueueConsumer;
    private final KafkaProperties kafkaProperties;
    private final PrivilegeInspector privilegeInspector;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.createSystemConsumer(this.kafkaSystemQueue, (MessageListener<String, String>)((MessageListener)this.systemQueueConsumer::consumeEvent));
        this.privilegeInspector.readPrivileges(MdcUtils.getRid());
    }

    private void createSystemConsumer(String name, MessageListener<String, String> consumeEvent) {
        log.info("Creating kafka consumer for topic {}", (Object)name);
        ContainerProperties containerProps = new ContainerProperties(new String[]{name});
        Map props = this.kafkaProperties.buildConsumerProperties();
        props.put("metadata.max.age.ms", this.kafkaMetadataMaxAge);
        DefaultKafkaConsumerFactory factory = new DefaultKafkaConsumerFactory(props);
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer((ConsumerFactory)factory, containerProps);
        container.setupMessageListener(consumeEvent);
        container.start();
        log.info("Successfully created kafka consumer for topic {}", (Object)name);
    }

    public ApplicationStartup(SystemQueueConsumer systemQueueConsumer, KafkaProperties kafkaProperties, PrivilegeInspector privilegeInspector) {
        this.systemQueueConsumer = systemQueueConsumer;
        this.kafkaProperties = kafkaProperties;
        this.privilegeInspector = privilegeInspector;
    }
}

