/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.db.service;

import com.icthh.xm.commons.domainevent.config.Column;
import com.icthh.xm.commons.domainevent.config.DbSourceConfig;
import com.icthh.xm.commons.domainevent.config.EntityFilter;
import com.icthh.xm.commons.domainevent.config.Query;
import com.icthh.xm.commons.domainevent.config.XmDomainEventConfiguration;
import com.icthh.xm.commons.domainevent.db.domain.JpaEntityContext;
import com.icthh.xm.commons.domainevent.db.domain.State;
import com.icthh.xm.commons.domainevent.db.service.DatabaseDslFilter;
import com.icthh.xm.commons.domainevent.db.service.DatabaseFilter;
import com.icthh.xm.commons.domainevent.db.service.mapper.JpaEntityMapper;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.domain.enums.DefaultDomainEventOperation;
import com.icthh.xm.commons.domainevent.domain.enums.DefaultDomainEventSource;
import com.icthh.xm.commons.domainevent.service.EventPublisher;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.Table;
import javax.persistence.metamodel.Metamodel;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.EmptyInterceptor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"application.domain-event.enabled"}, havingValue="true")
public class DatabaseSourceInterceptor
extends EmptyInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSourceInterceptor.class);
    private static final Map<Class<?>, String> TABLE_NAME_CACHE = new ConcurrentHashMap();
    private final EntityManager entityManager;
    private final XmDomainEventConfiguration xmDomainEventConfiguration;
    private final EventPublisher eventPublisher;
    private final JpaEntityMapper jpaEntityMapper;
    private final DatabaseFilter databaseFilter;
    private final DatabaseDslFilter databaseDslFilter;
    private final TenantContextHolder tenantContextHolder;

    @IgnoreLogginAspect
    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        this.publishEvent(entity, id, currentState, previousState, propertyNames, DefaultDomainEventOperation.UPDATE);
        return super.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
    }

    @IgnoreLogginAspect
    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.publishEvent(entity, id, state, null, propertyNames, DefaultDomainEventOperation.CREATE);
        return super.onSave(entity, id, state, propertyNames, types);
    }

    @IgnoreLogginAspect
    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.publishEvent(entity, id, null, state, propertyNames, DefaultDomainEventOperation.DELETE);
        super.onDelete(entity, id, state, propertyNames, types);
    }

    private void publishEvent(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, DefaultDomainEventOperation operation) {
        DbSourceConfig sourceConfig = this.xmDomainEventConfiguration.getDbSourceConfig(this.tenantContextHolder.getTenantKey(), DefaultDomainEventSource.DB.getCode());
        if (sourceConfig != null && sourceConfig.isEnabled() && sourceConfig.getFilter() != null) {
            String tableName = this.findTableName(entity);
            log.trace("publishEvent: tableName: {}, id: {}, operation: {}", new Object[]{tableName, id, operation});
            JpaEntityContext context = this.buildJpaEntityContext(entity, id, currentState, previousState, propertyNames, operation);
            if (this.isIntercepted(tableName, sourceConfig, context)) {
                DomainEvent dbDomainEvent = this.jpaEntityMapper.map(context);
                log.trace("DomainEvent before publish: {}", (Object)dbDomainEvent);
                this.eventPublisher.publish(DefaultDomainEventSource.DB.getCode(), dbDomainEvent);
            }
        }
    }

    private String findTableName(Object entity) {
        String tableName;
        Class<?> entityClass = entity.getClass();
        if (TABLE_NAME_CACHE.containsKey(entityClass)) {
            return TABLE_NAME_CACHE.get(entityClass);
        }
        Table tableAnnotation = entityClass.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            tableName = tableAnnotation.name();
        } else {
            log.warn("Entity: {} hasn't @Table annotation", (Object)entityClass.getSimpleName());
            tableName = this.findTableNameByHibernateNamingStrategy(entity);
        }
        TABLE_NAME_CACHE.put(entityClass, tableName);
        log.info("For domain class {} found corresponded table name {}", (Object)entityClass.getSimpleName(), (Object)tableName);
        return tableName;
    }

    private String findTableNameByHibernateNamingStrategy(Object entity) {
        MetamodelImplementor metamodelImplementor;
        EntityPersister entityPersister;
        Metamodel metamodel = this.entityManager.getMetamodel();
        String tableName = "";
        if (metamodel instanceof MetamodelImplementor && (entityPersister = (metamodelImplementor = (MetamodelImplementor)metamodel).locateEntityPersister(entity.getClass())) instanceof AbstractEntityPersister) {
            AbstractEntityPersister abstractEntityPersister = (AbstractEntityPersister)entityPersister;
            tableName = abstractEntityPersister.getTableName();
        }
        log.info("Table name by hibernate name strategy: {}", (Object)tableName);
        return tableName;
    }

    private JpaEntityContext buildJpaEntityContext(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, DefaultDomainEventOperation domainEventOperation) {
        return JpaEntityContext.builder().entity(entity).id(id).propertyNameToStates(this.mapPropertyValueToState(propertyNames, previousState, currentState)).domainEventOperation(domainEventOperation).build();
    }

    private Map<String, State> mapPropertyValueToState(String[] propertyNames, Object[] previousState, Object[] currentState) {
        LinkedHashMap<String, State> propertyNameToStates = new LinkedHashMap<String, State>();
        for (int i = 0; i < propertyNames.length; ++i) {
            Object previousStateValue = previousState != null ? previousState[i] : null;
            Object currentStateValue = currentState != null ? currentState[i] : null;
            propertyNameToStates.put(propertyNames[i], new State(previousStateValue, currentStateValue));
        }
        return propertyNameToStates;
    }

    private boolean isIntercepted(String tableName, DbSourceConfig sourceConfig, JpaEntityContext context) {
        String key = sourceConfig.getFilter().getKey();
        Boolean needFiltering = this.databaseFilter.lepFiltering(key, tableName, context);
        if (needFiltering == null) {
            Map dsl = sourceConfig.getFilter().getDsl();
            log.trace("No lep executed, going to process DSL: {}", (Object)dsl);
            if (dsl.containsKey(tableName)) {
                List filters = (List)dsl.get(tableName);
                Boolean invoked = this.lepInvoked(filters, tableName, context);
                return Objects.requireNonNullElseGet(invoked, () -> this.anyMatchQuery(filters, context));
            }
            return false;
        }
        return needFiltering;
    }

    private Boolean lepInvoked(List<EntityFilter> filters, String tableName, JpaEntityContext context) {
        Boolean invoked = null;
        for (EntityFilter filter : filters) {
            Boolean result = this.databaseDslFilter.lepFiltering(filter.getKey(), tableName, context);
            if (Boolean.TRUE.equals(result)) {
                return true;
            }
            if (!Objects.nonNull(result)) continue;
            invoked = result;
        }
        return invoked;
    }

    private boolean anyMatchQuery(List<EntityFilter> filters, JpaEntityContext context) {
        return filters.stream().anyMatch(filter -> this.processQuery(filter.getQuery(), context));
    }

    private boolean processQuery(Query query, JpaEntityContext context) {
        log.trace("Query: {}", (Object)query);
        if (Objects.isNull(query)) {
            return false;
        }
        log.trace("JpaEntityContext: {}", (Object)context);
        for (Map.Entry columnEntry : query.getColumns().entrySet()) {
            String propertyStateValue;
            String queryColumn = (String)columnEntry.getKey();
            if (!context.getPropertyNameToStates().containsKey(queryColumn) || !StringUtils.isNotEmpty((CharSequence)(propertyStateValue = context.findPropertyStateValue(queryColumn)))) continue;
            Column column = (Column)columnEntry.getValue();
            return column.match(propertyStateValue);
        }
        return false;
    }

    public DatabaseSourceInterceptor(EntityManager entityManager, XmDomainEventConfiguration xmDomainEventConfiguration, EventPublisher eventPublisher, JpaEntityMapper jpaEntityMapper, DatabaseFilter databaseFilter, DatabaseDslFilter databaseDslFilter, TenantContextHolder tenantContextHolder) {
        this.entityManager = entityManager;
        this.xmDomainEventConfiguration = xmDomainEventConfiguration;
        this.eventPublisher = eventPublisher;
        this.jpaEntityMapper = jpaEntityMapper;
        this.databaseFilter = databaseFilter;
        this.databaseDslFilter = databaseDslFilter;
        this.tenantContextHolder = tenantContextHolder;
    }
}

