/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.db.service.kafka;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.domainevent.db.service.kafka.SystemConsumerService;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.messaging.event.system.SystemEvent;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.lep.api.LepManager;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class SystemQueueConsumer {
    private static final Logger log = LoggerFactory.getLogger(SystemQueueConsumer.class);
    private final TenantContextHolder tenantContextHolder;
    private final XmAuthenticationContextHolder authContextHolder;
    private final SystemConsumerService systemConsumerService;
    private final LepManager lepManager;

    public SystemQueueConsumer(TenantContextHolder tenantContextHolder, XmAuthenticationContextHolder authContextHolder, SystemConsumerService systemConsumerService, LepManager lepManager) {
        this.tenantContextHolder = tenantContextHolder;
        this.authContextHolder = authContextHolder;
        this.systemConsumerService = systemConsumerService;
        this.lepManager = lepManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(maxAttemptsExpression="${application.retry.max-attempts}", backoff=@Backoff(delayExpression="${application.retry.delay}", multiplierExpression="${application.retry.multiplier}"))
    public void consumeEvent(ConsumerRecord<String, String> message) {
        MdcUtils.putRid();
        try {
            SystemEvent event;
            block7: {
                log.info("Consume event from topic [{}]", (Object)message.topic());
                ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                mapper.registerModule((Module)new JavaTimeModule());
                event = (SystemEvent)mapper.readValue((String)message.value(), SystemEvent.class);
                log.info("Process event from topic [{}], {}", (Object)message.topic(), (Object)event);
                if (!StringUtils.isBlank((CharSequence)event.getTenantKey())) break block7;
                log.info("Event ignored due to tenantKey is empty {}", (Object)event);
                return;
            }
            try {
                this.init(event.getTenantKey(), event.getUserLogin());
                this.systemConsumerService.acceptSystemEvent(event);
            }
            catch (IOException e) {
                log.error("System queue message has incorrect format: '{}'", message.value(), (Object)e);
            }
        }
        finally {
            this.destroy();
        }
    }

    private void init(String tenantKey, String login) {
        if (StringUtils.isNotBlank((CharSequence)tenantKey)) {
            TenantContextUtils.setTenant((TenantContextHolder)this.tenantContextHolder, (String)tenantKey);
            this.lepManager.beginThreadContext(threadContext -> {
                threadContext.setValue("tenantContext", (Object)this.tenantContextHolder.getContext());
                threadContext.setValue("authContext", (Object)this.authContextHolder.getContext());
            });
        }
        String newRid = MdcUtils.getRid() + ":" + (String)StringUtils.defaultIfBlank((CharSequence)login, (CharSequence)"") + ":" + (String)StringUtils.defaultIfBlank((CharSequence)tenantKey, (CharSequence)"");
        MdcUtils.putRid((String)newRid);
    }

    private void destroy() {
        this.lepManager.endThreadContext();
        this.tenantContextHolder.getPrivilegedContext().destroyCurrentContext();
        MdcUtils.removeRid();
    }
}

