/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.db.service.mapper.impl;

import com.icthh.xm.commons.domainevent.db.domain.JpaEntityContext;
import com.icthh.xm.commons.domainevent.db.domain.State;
import com.icthh.xm.commons.domainevent.db.lep.TypeKeyAwareEntityResolver;
import com.icthh.xm.commons.domainevent.db.service.mapper.JpaEntityMapper;
import com.icthh.xm.commons.domainevent.domain.DbDomainEventPayload;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.domain.DomainEventPayload;
import com.icthh.xm.commons.domainevent.service.builder.DomainEventFactory;
import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.spring.LepService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LepService(group="event.db.mapper")
public class TypeKeyAwareJpaEntityMapper
implements JpaEntityMapper {
    private static final Logger log = LoggerFactory.getLogger(TypeKeyAwareJpaEntityMapper.class);
    public static final String TYPE_KEY = "typeKey";
    private final DomainEventFactory domainEventFactory;

    @Override
    @LogicExtensionPoint(value="TypeKey", resolver=TypeKeyAwareEntityResolver.class)
    public DomainEvent map(JpaEntityContext jpaEntityContext) {
        DomainEventPayload dbDomainEventPayload = this.buildDomainEventPayload(jpaEntityContext);
        return this.domainEventFactory.build(jpaEntityContext.getDomainEventOperation(), UUID.randomUUID(), jpaEntityContext.getId().toString(), jpaEntityContext.findPropertyStateValue(TYPE_KEY), dbDomainEventPayload);
    }

    DomainEventPayload buildDomainEventPayload(JpaEntityContext jpaEntityContext) {
        LinkedHashMap<String, Object> before = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> after = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, State> propertyNameToState : jpaEntityContext.getPropertyNameToStates().entrySet()) {
            String propertyName = propertyNameToState.getKey();
            State propertyState = propertyNameToState.getValue();
            before.put(propertyName, propertyState.getPrevious());
            after.put(propertyName, propertyState.getCurrent());
        }
        DbDomainEventPayload domainEventPayload = new DbDomainEventPayload();
        domainEventPayload.setBefore(before);
        domainEventPayload.setAfter(after);
        return domainEventPayload;
    }

    public TypeKeyAwareJpaEntityMapper(DomainEventFactory domainEventFactory) {
        this.domainEventFactory = domainEventFactory;
    }
}

