/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.outbox.domain;

import com.icthh.xm.commons.domainevent.outbox.domain.RecordStatus;
import com.icthh.xm.commons.domainevent.outbox.domain.ValidFor;
import com.icthh.xm.commons.domainevent.outbox.domain.converter.MapToStringConverter;
import com.icthh.xm.commons.migration.db.jsonb.Jsonb;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.Persistable;

@Entity
@Table(name="outbox")
public class Outbox
implements Serializable,
Persistable<UUID> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UUID")
    @Column(name="id", updatable=false, nullable=false)
    private UUID id;
    @NotNull
    @Column(name="tx_id")
    private String txId;
    @NotNull
    @Column(name="event_date")
    private Instant eventDate;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private RecordStatus status;
    @NotNull
    @Column(name="aggregate_id")
    private String aggregateId;
    @NotNull
    @Column(name="aggregate_type")
    private String aggregateType;
    @NotNull
    @Column(name="operation")
    private String operation;
    @NotNull
    @Column(name="source")
    private String source;
    @Column(name="user_key")
    private String userKey;
    @NotNull
    @Column(name="client_id")
    private String clientId;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="validFrom", column=@Column(name="valid_from")), @AttributeOverride(name="validTo", column=@Column(name="valid_to"))})
    private ValidFor validFor;
    @Jsonb
    @Convert(converter=MapToStringConverter.class)
    @Column(name="meta")
    private Map<String, Object> meta;
    @Jsonb
    @Convert(converter=MapToStringConverter.class)
    @Column(name="payload")
    private Map<String, Object> payload;

    public UUID getId() {
        return this.id;
    }

    public boolean isNew() {
        return this.id == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Outbox outbox = (Outbox)o;
        return Objects.equals(this.id, outbox.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @NotNull
    public String getTxId() {
        return this.txId;
    }

    @NotNull
    public Instant getEventDate() {
        return this.eventDate;
    }

    @NotNull
    public RecordStatus getStatus() {
        return this.status;
    }

    @NotNull
    public String getAggregateId() {
        return this.aggregateId;
    }

    @NotNull
    public String getAggregateType() {
        return this.aggregateType;
    }

    @NotNull
    public String getOperation() {
        return this.operation;
    }

    @NotNull
    public String getSource() {
        return this.source;
    }

    public String getUserKey() {
        return this.userKey;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    public ValidFor getValidFor() {
        return this.validFor;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTxId(@NotNull String txId) {
        this.txId = txId;
    }

    public void setEventDate(@NotNull Instant eventDate) {
        this.eventDate = eventDate;
    }

    public void setStatus(@NotNull RecordStatus status) {
        this.status = status;
    }

    public void setAggregateId(@NotNull String aggregateId) {
        this.aggregateId = aggregateId;
    }

    public void setAggregateType(@NotNull String aggregateType) {
        this.aggregateType = aggregateType;
    }

    public void setOperation(@NotNull String operation) {
        this.operation = operation;
    }

    public void setSource(@NotNull String source) {
        this.source = source;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public void setClientId(@NotNull String clientId) {
        this.clientId = clientId;
    }

    public void setValidFor(ValidFor validFor) {
        this.validFor = validFor;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public void setPayload(Map<String, Object> payload) {
        this.payload = payload;
    }
}

