/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.outbox.domain.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class MapToStringConverter
implements AttributeConverter<Map<String, Object>, String> {
    private static final Logger log = LoggerFactory.getLogger(MapToStringConverter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public MapToStringConverter() {
        this.mapper.registerModule((Module)new JavaTimeModule());
    }

    public String convertToDatabaseColumn(Map<String, Object> data) {
        try {
            return this.mapper.writeValueAsString(data != null ? data : Map.of());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot convert map to JSON string", e);
        }
    }

    public Map<String, Object> convertToEntityAttribute(String data) {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)this.mapper.readValue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{data}) ? data : "{}", (TypeReference)typeRef);
        }
        catch (IOException e) {
            log.warn("Error during String to JSON converting", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

