/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.outbox.service;

import com.google.common.collect.Iterables;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.outbox.domain.Outbox;
import com.icthh.xm.commons.domainevent.outbox.domain.RecordStatus;
import com.icthh.xm.commons.domainevent.outbox.repository.OutboxRepository;
import com.icthh.xm.commons.domainevent.outbox.service.mapper.DomainEventMapper;
import com.icthh.xm.commons.lep.api.LepAdditionalContext;
import com.icthh.xm.commons.lep.api.LepAdditionalContextField;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class OutboxTransportService
implements LepAdditionalContext<OutboxTransportService> {
    private final OutboxRepository outboxRepository;
    private final DomainEventMapper domainEventMapper;

    public Page<DomainEvent> findAll(Specification<Outbox> filter, Pageable pageable) {
        return this.outboxRepository.findAll(filter, pageable).map(this.domainEventMapper::toEntity);
    }

    public void changeStatus(RecordStatus status, Iterable<UUID> ids) {
        if (ids == null || Iterables.isEmpty(ids)) {
            return;
        }
        this.outboxRepository.updateStatus(status, ids);
    }

    public void changeStatusById(RecordStatus status, UUID id) {
        this.outboxRepository.updateStatus(status, id);
    }

    @IgnoreLogginAspect
    public String additionalContextKey() {
        return "outboxTransportService";
    }

    @IgnoreLogginAspect
    public OutboxTransportService additionalContextValue() {
        return this;
    }

    public Class<? extends LepAdditionalContextField> fieldAccessorInterface() {
        return OutboxTransportServiceField.class;
    }

    public OutboxTransportService(OutboxRepository outboxRepository, DomainEventMapper domainEventMapper) {
        this.outboxRepository = outboxRepository;
        this.domainEventMapper = domainEventMapper;
    }

    public static interface OutboxTransportServiceField
    extends LepAdditionalContextField {
        public static final String FIELD_NAME = "outboxTransportService";

        default public OutboxTransportService getOutboxTransportService() {
            return (OutboxTransportService)this.get(FIELD_NAME);
        }
    }
}

