/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.outbox.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.domain.DomainEventPayload;
import com.icthh.xm.commons.domainevent.outbox.domain.Outbox;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Mapper(componentModel="spring")
public abstract class DomainEventMapper {
    private String msName;
    private TenantContextHolder tenantContextHolder;
    private ObjectMapper objectMapper;

    @Value(value="${spring.application.name}")
    public void setMsName(String msName) {
        this.msName = msName;
    }

    @Autowired
    public void setTenantContextHolder(TenantContextHolder tenantContextHolder) {
        this.tenantContextHolder = tenantContextHolder;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.copy();
    }

    @Mappings(value={@Mapping(target="payload", source="payload", qualifiedByName={"mapToDtoPayload"}), @Mapping(target="status", constant="NEW")})
    public abstract Outbox toDto(DomainEvent var1);

    @Mappings(value={@Mapping(target="msName", constant="ignored", qualifiedByName={"mapMsName"}), @Mapping(target="tenant", constant="ignored", qualifiedByName={"mapTenant"}), @Mapping(target="payload", source="payload", qualifiedByName={"mapToPayload"})})
    public abstract DomainEvent toEntity(Outbox var1);

    @Named(value="mapMsName")
    String mapMsName(String ignored) {
        return this.msName;
    }

    @Named(value="mapTenant")
    String mapTenant(String ignored) {
        return this.tenantContextHolder == null ? null : this.tenantContextHolder.getTenantKey();
    }

    @Named(value="mapToPayload")
    DomainEventPayload mapToPayload(Map<String, Object> payload) throws ClassNotFoundException {
        return (DomainEventPayload)this.objectMapper.convertValue(payload, DomainEventPayload.class);
    }

    @Named(value="mapToDtoPayload")
    Map<String, Object> mapToDtoPayload(DomainEventPayload payload) {
        return (Map)this.objectMapper.convertValue((Object)payload, Map.class);
    }
}

