/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.outbox.service.mapper;

import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.domain.ValidFor;
import com.icthh.xm.commons.domainevent.outbox.domain.Outbox;
import com.icthh.xm.commons.domainevent.outbox.domain.RecordStatus;
import com.icthh.xm.commons.domainevent.outbox.service.mapper.DomainEventMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DomainEventMapperImpl
extends DomainEventMapper {
    @Override
    public Outbox toDto(DomainEvent domainEvent) {
        if (domainEvent == null) {
            return null;
        }
        Outbox outbox = new Outbox();
        outbox.setPayload(this.mapToDtoPayload(domainEvent.getPayload()));
        outbox.setId(domainEvent.getId());
        outbox.setTxId(domainEvent.getTxId());
        outbox.setEventDate(domainEvent.getEventDate());
        outbox.setAggregateId(domainEvent.getAggregateId());
        outbox.setAggregateType(domainEvent.getAggregateType());
        outbox.setOperation(domainEvent.getOperation());
        outbox.setSource(domainEvent.getSource());
        outbox.setUserKey(domainEvent.getUserKey());
        outbox.setClientId(domainEvent.getClientId());
        outbox.setValidFor(this.validForToValidFor(domainEvent.getValidFor()));
        Map map1 = domainEvent.getMeta();
        if (map1 != null) {
            outbox.setMeta(new LinkedHashMap<String, Object>(map1));
        }
        outbox.setStatus(RecordStatus.NEW);
        return outbox;
    }

    @Override
    public DomainEvent toEntity(Outbox outbox) {
        if (outbox == null) {
            return null;
        }
        DomainEvent.DomainEventBuilder domainEvent = DomainEvent.builder();
        try {
            domainEvent.payload(this.mapToPayload(outbox.getPayload()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        domainEvent.id(outbox.getId());
        domainEvent.txId(outbox.getTxId());
        domainEvent.eventDate(outbox.getEventDate());
        domainEvent.aggregateId(outbox.getAggregateId());
        domainEvent.aggregateType(outbox.getAggregateType());
        domainEvent.operation(outbox.getOperation());
        domainEvent.source(outbox.getSource());
        domainEvent.userKey(outbox.getUserKey());
        domainEvent.clientId(outbox.getClientId());
        domainEvent.validFor(this.validForToValidFor1(outbox.getValidFor()));
        Map<String, Object> map = outbox.getMeta();
        if (map != null) {
            domainEvent.meta(new LinkedHashMap<String, Object>(map));
        }
        domainEvent.msName(this.mapMsName("ignored"));
        domainEvent.tenant(this.mapTenant("ignored"));
        return domainEvent.build();
    }

    protected com.icthh.xm.commons.domainevent.outbox.domain.ValidFor validForToValidFor(ValidFor validFor) {
        if (validFor == null) {
            return null;
        }
        com.icthh.xm.commons.domainevent.outbox.domain.ValidFor validFor1 = new com.icthh.xm.commons.domainevent.outbox.domain.ValidFor();
        validFor1.setValidFrom(validFor.getValidFrom());
        validFor1.setValidTo(validFor.getValidTo());
        return validFor1;
    }

    protected ValidFor validForToValidFor1(com.icthh.xm.commons.domainevent.outbox.domain.ValidFor validFor) {
        if (validFor == null) {
            return null;
        }
        ValidFor validFor1 = new ValidFor();
        validFor1.setValidFrom(validFor.getValidFrom());
        validFor1.setValidTo(validFor.getValidTo());
        return validFor1;
    }
}

